/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.rest.backend.cmd;

import java.util.Map;
import org.guvnor.rest.backend.JobRequestHelper;
import org.guvnor.rest.backend.JobResultManager;
import org.guvnor.rest.client.JobRequest;
import org.guvnor.rest.client.JobResult;
import org.guvnor.rest.client.JobStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.async.DescriptiveRunnable;

public abstract class AbstractJobCommand
implements DescriptiveRunnable {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractJobCommand.class);
    public static final String JOB_REQUEST_KEY = "JobRequest";
    protected final JobRequestHelper jobRequestHelper;
    protected final JobResultManager jobResultManager;
    protected final Map<String, Object> context;

    public AbstractJobCommand(JobRequestHelper jobRequestHelper, JobResultManager jobResultManager, Map<String, Object> context) {
        this.jobRequestHelper = jobRequestHelper;
        this.jobResultManager = jobResultManager;
        this.context = context;
    }

    protected JobRequestHelper getHelper() throws Exception {
        return this.jobRequestHelper;
    }

    protected JobRequest getJobRequest() {
        JobRequest jobRequest = (JobRequest)this.context.get(JOB_REQUEST_KEY);
        if (jobRequest != null) {
            return jobRequest;
        }
        throw new RuntimeException("Unable to find JobRequest");
    }

    private JobResultManager getJobManager() throws Exception {
        return this.jobResultManager;
    }

    public String getDescription() {
        return "Command class " + this.getClass().getName();
    }

    public void run() {
        block4: {
            try {
                JobRequest request = this.getJobRequest();
                JobResult result = this.createResult(request);
                logger.debug("--- job {} ---, status: {}", (Object)result.getJobId(), (Object)result.getStatus());
                JobResultManager jobMgr = this.getJobManager();
                result.setLastModified(System.currentTimeMillis());
                jobMgr.putJob(result);
                if (!JobStatus.APPROVED.equals((Object)request.getStatus())) break block4;
                try {
                    result = this.internalExecute(request);
                }
                catch (Exception e) {
                    result.setStatus(JobStatus.SERVER_ERROR);
                    result.setResult("Request failed because of " + e.getClass().getSimpleName() + ": " + e.getMessage());
                    logger.error("{} [{}] failed because of thrown {}: {}", new Object[]{request.getClass().getSimpleName(), request.getJobId(), e.getClass().getSimpleName(), e.getMessage(), e});
                }
                logger.debug("--- job {} ---, status: {}", (Object)result.getJobId(), (Object)result.getStatus());
                result.setLastModified(System.currentTimeMillis());
                jobMgr.putJob(result);
            }
            catch (Throwable e) {
                logger.error("Error executing job class: {}, error: {}", (Object)this.getClass().getName(), (Object)e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }

    private JobResult createResult(JobRequest jobRequest) {
        JobResult jobResult = new JobResult();
        jobResult.setJobId(jobRequest.getJobId());
        jobResult.setStatus(jobRequest.getStatus());
        return jobResult;
    }

    protected abstract JobResult internalExecute(JobRequest var1) throws Exception;
}

