/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters;

import java.util.function.Function;
import org.eclipse.bpmn2.Bpmn2Factory;
import org.eclipse.bpmn2.EventSubprocess;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.ManualTask;
import org.eclipse.bpmn2.ReceiveTask;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.impl.UserTaskImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Match;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingRequest;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MatchTest {
    @Mock
    private BpmnNode defaultValue;
    @Mock
    private Function<UserTaskImpl, BpmnNode> assertUserTask;
    @Mock
    private Function<FlowElement, BpmnNode> fallback;
    @Mock
    private Function<SubProcess, BpmnNode> assertSubProcess;
    @Mock
    private BpmnNode fallbackNode;

    @Before
    public void setUp() {
        Mockito.when((Object)this.fallback.apply((FlowElement)Matchers.any())).thenReturn((Object)this.fallbackNode);
    }

    @Test
    public void whenExactlyTest() {
        UserTaskImpl element = (UserTaskImpl)Bpmn2Factory.eINSTANCE.createUserTask();
        Result result = this.match().apply((Object)element);
        ((Function)Mockito.verify(this.assertUserTask)).apply(element);
        Assert.assertTrue((boolean)result.isSuccess());
    }

    @Test
    public void whenTest() {
        EventSubprocess element = Bpmn2Factory.eINSTANCE.createEventSubprocess();
        Result result = this.match().apply((Object)element);
        ((Function)Mockito.verify(this.assertSubProcess)).apply(element);
        Assert.assertNotEquals((Object)result.value(), (Object)this.defaultValue);
        Assert.assertTrue((boolean)result.isSuccess());
    }

    @Test
    public void testFallback() {
        StartEvent element = Bpmn2Factory.eINSTANCE.createStartEvent();
        Result result = this.match().orElse(this.fallback).apply((Object)element);
        ((Function)Mockito.verify(this.fallback)).apply(element);
        Assert.assertNotEquals((Object)result.value(), (Object)this.defaultValue);
        Assert.assertEquals((Object)result.value(), (Object)this.fallbackNode);
        Assert.assertTrue((boolean)result.isSuccess());
    }

    @Test
    public void ignoreTestAuto() {
        ManualTask element = Bpmn2Factory.eINSTANCE.createManualTask();
        Result result = this.match().apply((Object)element);
        Assert.assertEquals((Object)result.value(), (Object)this.defaultValue);
        Assert.assertTrue((boolean)result.isIgnored());
        Assert.assertFalse((boolean)result.isFailure());
    }

    @Test
    public void ignoreTestIgnore() {
        ManualTask element = Bpmn2Factory.eINSTANCE.createManualTask();
        Result result = this.match().mode(MarshallingRequest.Mode.IGNORE).apply((Object)element);
        Assert.assertEquals((Object)result.value(), (Object)this.defaultValue);
        Assert.assertTrue((boolean)result.isIgnored());
        Assert.assertFalse((boolean)result.isFailure());
    }

    @Test
    public void ignoreTestError() {
        ManualTask element = Bpmn2Factory.eINSTANCE.createManualTask();
        Result result = this.match().mode(MarshallingRequest.Mode.ERROR).apply((Object)element);
        Assert.assertEquals((Object)result.value(), (Object)this.defaultValue);
        Assert.assertFalse((boolean)result.isIgnored());
        Assert.assertTrue((boolean)result.isFailure());
    }

    @Test
    public void missingTest() {
        ReceiveTask element = Bpmn2Factory.eINSTANCE.createReceiveTask();
        Result result = this.match().apply((Object)element);
        Assert.assertEquals((Object)result.value(), (Object)this.defaultValue);
        Assert.assertTrue((boolean)result.isFailure());
    }

    private Match<FlowElement, BpmnNode> match() {
        return Match.of(FlowElement.class, BpmnNode.class).whenExactly(UserTaskImpl.class, this.assertUserTask).when(SubProcess.class, this.assertSubProcess).ignore(ManualTask.class).missing(ReceiveTask.class).defaultValue((Object)this.defaultValue).mode(MarshallingRequest.Mode.AUTO);
    }
}

