/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.rule.ext.impl;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.util.ParentTypesMatcher;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;
import org.kie.workbench.common.stunner.core.rule.context.GraphConnectionContext;
import org.kie.workbench.common.stunner.core.rule.context.GraphEvaluationState;
import org.kie.workbench.common.stunner.core.rule.ext.RuleExtension;
import org.kie.workbench.common.stunner.core.rule.ext.impl.AbstractParentsMatchHandler;
import org.kie.workbench.common.stunner.core.rule.handler.impl.GraphEvaluationHandlerUtils;
import org.kie.workbench.common.stunner.core.rule.violations.DefaultRuleViolations;

@ApplicationScoped
public class ConnectorParentsMatchConnectionHandler
extends AbstractParentsMatchHandler<ConnectorParentsMatchConnectionHandler, GraphConnectionContext> {
    private final DefinitionManager definitionManager;
    private final GraphEvaluationHandlerUtils evalUtils;

    protected ConnectorParentsMatchConnectionHandler() {
        this(null);
    }

    @Inject
    public ConnectorParentsMatchConnectionHandler(DefinitionManager definitionManager) {
        this.definitionManager = definitionManager;
        this.evalUtils = new GraphEvaluationHandlerUtils(definitionManager);
    }

    public Class<ConnectorParentsMatchConnectionHandler> getExtensionType() {
        return ConnectorParentsMatchConnectionHandler.class;
    }

    public Class<GraphConnectionContext> getContextType() {
        return GraphConnectionContext.class;
    }

    public boolean accepts(RuleExtension rule, GraphConnectionContext context) {
        return this.acceptsConnection(rule, context);
    }

    public RuleViolations evaluate(RuleExtension rule, GraphConnectionContext context) {
        return this.evaluateConnection(rule, context);
    }

    private boolean acceptsConnection(RuleExtension rule, GraphConnectionContext context) {
        Edge connector = context.getConnector();
        return this.evalUtils.getElementDefinitionId((Element<?>)connector).equals(rule.getId());
    }

    private RuleViolations evaluateConnection(RuleExtension rule, GraphConnectionContext context) {
        Edge connector = context.getConnector();
        GraphEvaluationState.ConnectionState connectionState = context.getState().getConnectionState();
        Node sourceNode = context.getSource().orElse(connectionState.getSource(connector));
        Node targetNode = context.getTarget().orElse(connectionState.getTarget(connector));
        DefaultRuleViolations result = new DefaultRuleViolations();
        GraphEvaluationState.ContainmentState containmentState = context.getState().getContainmentState();
        boolean isValid = new ParentTypesMatcher(() -> this.definitionManager, arg_0 -> ((GraphEvaluationState.ContainmentState)containmentState).getParent(arg_0), rule.getTypeArguments()).matcher().test(sourceNode, targetNode);
        if (!isValid) {
            this.addViolation(context.getConnector().getUUID(), rule, result);
        }
        return result;
    }
}

