/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.transfer.rest;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.dashbuilder.transfer.DataTransferExportModel;
import org.dashbuilder.transfer.DataTransferServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Paths;

@ApplicationScoped
@Path(value="dashbuilder")
public class DataTransferResource {
    Logger logger = LoggerFactory.getLogger(DataTransferResource.class);
    @Inject
    private DataTransferServices dataTransferServices;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;

    @GET
    @Path(value="export")
    @Produces(value={"application/zip"})
    public Response export() {
        try {
            String exportFile = this.dataTransferServices.doExport(DataTransferExportModel.exportAll());
            org.uberfire.java.nio.file.Path path = Paths.get((String)exportFile, (String[])new String[0]);
            return Response.ok((Object)this.ioService.readAllBytes(path)).build();
        }
        catch (Exception e) {
            String errorMessage = "Error creating export: " + e.getMessage();
            this.logger.error(errorMessage);
            this.logger.debug("Not able to create export.", (Throwable)e);
            return Response.serverError().entity((Object)errorMessage).build();
        }
    }
}

