/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.model;

import java.util.Optional;
import java.util.Set;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.jboss.errai.databinding.client.api.Bindable;
import org.kie.soup.commons.util.Sets;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.api.property.DMNPropertySet;
import org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.LocationURI;
import org.kie.workbench.common.forms.adf.definitions.annotations.FieldParam;
import org.kie.workbench.common.forms.adf.definitions.annotations.FormDefinition;
import org.kie.workbench.common.forms.adf.definitions.annotations.FormField;
import org.kie.workbench.common.forms.adf.definitions.settings.FieldPolicy;
import org.kie.workbench.common.stunner.core.definition.annotation.Definition;
import org.kie.workbench.common.stunner.core.definition.annotation.Property;
import org.kie.workbench.common.stunner.core.definition.annotation.PropertySet;
import org.kie.workbench.common.stunner.core.definition.annotation.definition.Category;
import org.kie.workbench.common.stunner.core.definition.annotation.definition.Labels;
import org.kie.workbench.common.stunner.core.domainobject.DomainObject;
import org.kie.workbench.common.stunner.core.factory.graph.NodeFactory;
import org.kie.workbench.common.stunner.core.util.HashUtil;
import org.kie.workbench.common.stunner.core.util.UUID;

@Portable
@Bindable
@PropertySet
@Definition(graphFactory=NodeFactory.class)
@FormDefinition(policy=FieldPolicy.ONLY_MARKED, defaultFieldSettings={@FieldParam(name="nestedFormContainer", value="COLLAPSIBLE")}, startElement="id")
public class ImportedValues
extends Import
implements DMNPropertySet,
DomainObject {
    @Category
    private static final String stunnerCategory = "DMNDomainObjects";
    @Labels
    private static final Set<String> stunnerLabels = new Sets.Builder().build();
    private final String UUID = org.kie.workbench.common.stunner.core.util.UUID.uuid();
    protected String importedElement;
    @Property
    @FormField
    protected ExpressionLanguage expressionLanguage;

    public ImportedValues() {
        this(null, new LocationURI(), null, null, null);
    }

    public ImportedValues(String namespace, LocationURI locationURI, String importType, String importedElement, ExpressionLanguage expressionLanguage) {
        super(namespace, locationURI, importType);
        this.importedElement = importedElement;
        this.expressionLanguage = expressionLanguage;
    }

    public ImportedValues copy() {
        ImportedValues clonedImportedValues = new ImportedValues();
        clonedImportedValues.id = new Id();
        clonedImportedValues.namespace = this.namespace;
        clonedImportedValues.locationURI = this.locationURI.copy();
        clonedImportedValues.importType = this.importType;
        clonedImportedValues.importedElement = this.importedElement;
        clonedImportedValues.expressionLanguage = Optional.ofNullable(this.expressionLanguage).map(ExpressionLanguage::copy).orElse(null);
        return clonedImportedValues;
    }

    public String getStunnerCategory() {
        return stunnerCategory;
    }

    public Set<String> getStunnerLabels() {
        return stunnerLabels;
    }

    public String getImportedElement() {
        return this.importedElement;
    }

    public void setImportedElement(String importedElement) {
        this.importedElement = importedElement;
    }

    public ExpressionLanguage getExpressionLanguage() {
        return this.expressionLanguage;
    }

    public void setExpressionLanguage(ExpressionLanguage expressionLanguage) {
        this.expressionLanguage = expressionLanguage;
    }

    public String getDomainObjectUUID() {
        return this.UUID;
    }

    public String getDomainObjectNameTranslationKey() {
        return "ImportedValues.DomainObjectName";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImportedValues)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImportedValues that = (ImportedValues)o;
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.locationURI != null ? !this.locationURI.equals(that.locationURI) : that.locationURI != null) {
            return false;
        }
        if (this.locationURI != null ? !this.locationURI.equals(that.locationURI) : that.locationURI != null) {
            return false;
        }
        if (this.importedElement != null ? !this.importedElement.equals(that.importedElement) : that.importedElement != null) {
            return false;
        }
        return this.expressionLanguage != null ? this.expressionLanguage.equals(that.expressionLanguage) : that.expressionLanguage == null;
    }

    @Override
    public int hashCode() {
        return HashUtil.combineHashCodes((int[])new int[]{this.namespace != null ? this.namespace.hashCode() : 0, this.locationURI != null ? this.locationURI.hashCode() : 0, this.importType != null ? this.importType.hashCode() : 0, this.importedElement != null ? this.importedElement.hashCode() : 0, this.expressionLanguage != null ? this.expressionLanguage.hashCode() : 0});
    }
}

