/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.graph;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.enterprise.context.Dependent;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;

@Dependent
public class DMNDiagramUtils {
    private static Definitions NONE = null;

    public List<DRGElement> getDRGElements(Diagram diagram) {
        return this.getDefinitionStream(diagram).filter(d -> d instanceof DRGElement).map(d -> (DRGElement)d).collect(Collectors.toList());
    }

    public String getNamespace(Diagram diagram) {
        return this.getDefinitionStream(diagram).filter(d -> d instanceof DMNDiagram).map(d -> (DMNDiagram)d).findFirst().map(DMNDiagram::getDefinitions).map(definitions -> definitions.getNamespace().getValue()).orElse("");
    }

    public Definitions getDefinitions(Diagram diagram) {
        return this.getDefinitionStream(diagram).filter(d -> d instanceof DMNDiagram).map(d -> (DMNDiagram)d).findFirst().map(DMNDiagram::getDefinitions).orElse(NONE);
    }

    private Stream<Object> getDefinitionStream(Diagram diagram) {
        return this.getNodeStream(diagram).map(Element::getContent).filter(c -> c instanceof Definition).map(c -> (Definition)c).map(Definition::getDefinition);
    }

    public Stream<Node> getNodeStream(Diagram diagram) {
        Graph graph = diagram.getGraph();
        return StreamSupport.stream(graph.nodes().spliterator(), false);
    }
}

