/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.workitem.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import org.jbpm.process.workitem.WorkDefinitionImpl;
import org.jbpm.process.workitem.WorkItemRepository;
import org.kie.workbench.common.stunner.bpmn.backend.workitem.WorkItemDefinitionParser;
import org.kie.workbench.common.stunner.bpmn.backend.workitem.service.WorkItemDefinitionRemoteRequest;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinition;
import org.kie.workbench.common.stunner.bpmn.workitem.service.WorkItemDefinitionService;
import org.kie.workbench.common.stunner.core.util.StringUtils;

@ApplicationScoped
public class WorkItemDefinitionRemoteService
implements WorkItemDefinitionService<WorkItemDefinitionRemoteRequest> {
    public static Function<String, WorkItemsHolder> DEFAULT_LOOKUP_SERVICE = url -> new WorkItemsHolder(WorkItemRepository.getWorkDefinitions((String)url));
    private final Function<String, WorkItemsHolder> lookupService;

    public WorkItemDefinitionRemoteService() {
        this(DEFAULT_LOOKUP_SERVICE);
    }

    WorkItemDefinitionRemoteService(Function<String, WorkItemsHolder> lookupService) {
        this.lookupService = lookupService;
    }

    public Collection<WorkItemDefinition> execute(WorkItemDefinitionRemoteRequest request) {
        return WorkItemDefinitionRemoteService.fetch(this.lookupService, request.getUri(), request.getNames());
    }

    public static Collection<WorkItemDefinition> fetch(Function<String, WorkItemsHolder> lookupService, String serviceRepoUrl, String[] names) {
        Map<String, WorkDefinitionImpl> workItemsMap;
        String defaultServiceRepo;
        String string = defaultServiceRepo = null != serviceRepoUrl && serviceRepoUrl.trim().length() > 0 ? serviceRepoUrl : null;
        if (defaultServiceRepo != null && !(workItemsMap = lookupService.apply(defaultServiceRepo).get()).isEmpty()) {
            Stream<WorkDefinitionImpl> items = WorkItemDefinitionRemoteService.isAllNames(names) ? workItemsMap.values().stream() : Arrays.stream(names).filter(workItemsMap::containsKey).map(workItemsMap::get);
            return items.map(wid -> WorkItemDefinitionParser.parse(wid, WorkItemDefinitionRemoteService::buildUri, WorkItemDefinitionParser::buildDataURIFromURL)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptySet();
    }

    private static String buildUri(WorkDefinitionImpl item) {
        String fileName;
        String path = null != item.getPath() ? item.getPath() : "";
        String string = fileName = null != item.getFile() ? item.getFile() : "";
        if (StringUtils.isEmpty((String)path)) {
            return null;
        }
        return path + "/" + fileName;
    }

    private static boolean isAllNames(String[] names) {
        return names == null || names.length == 0;
    }

    public static class WorkItemsHolder {
        private final Map<String, WorkDefinitionImpl> map;

        WorkItemsHolder(Map<String, WorkDefinitionImpl> map) {
            this.map = map;
        }

        public Map<String, WorkDefinitionImpl> get() {
            return this.map;
        }
    }
}

