/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ks.integration;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.jbpm.workbench.ks.integration.event.QueryDefinitionLoaded;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.definition.QueryDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.services.cdi.Startup;

@ApplicationScoped
@Startup
public class KieServerQueryDefinitionLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieServerQueryDefinitionLoader.class);
    @Inject
    Event<QueryDefinitionLoaded> event;

    @PostConstruct
    public void init() {
        this.loadDefaultQueryDefinitions();
    }

    protected void loadDefaultQueryDefinitions() {
        try (InputStream qdStream = this.getClass().getResourceAsStream("/default-query-definitions.json");){
            if (qdStream == null) {
                LOGGER.info("Default query definitions file default-query-definitions.json not found");
                return;
            }
            this.loadQueryDefinitions(qdStream, MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader()));
        }
        catch (Exception e) {
            LOGGER.error("Error when loading default query definitions from default-query-definitions.json", (Throwable)e);
        }
    }

    protected void loadQueryDefinitions(InputStream qdStream, Marshaller marshaller) throws IOException {
        String qdString = IOUtils.toString((InputStream)qdStream, (Charset)Charset.forName("UTF-8"));
        try {
            QueryDefinition[] queries = (QueryDefinition[])marshaller.unmarshall(qdString, QueryDefinition[].class);
            LOGGER.info("Found {} query definitions", (Object)(queries == null ? 0 : queries.length));
            if (queries == null) {
                return;
            }
            for (QueryDefinition q : queries) {
                LOGGER.info("Loaded query definition: {}", (Object)q);
                this.event.fire((Object)new QueryDefinitionLoaded(q));
            }
        }
        catch (MarshallingException e) {
            LOGGER.error("Error when unmarshalling query definitions from stream.", (Throwable)e);
        }
    }
}

