/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.bpmn.backend.converters.ResultComposer;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingMessage;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ResultComposerTest {
    Result result1;
    Result result2;
    Result result3;
    MarshallingMessage message1;
    MarshallingMessage message2;
    MarshallingMessage message3;
    @Mock
    private Object value;

    @Before
    public void setUp() {
        this.message1 = MarshallingMessage.builder().build();
        this.message2 = MarshallingMessage.builder().build();
        this.message3 = MarshallingMessage.builder().build();
        this.result1 = Result.success((Object)this.value, (MarshallingMessage[])new MarshallingMessage[]{this.message1});
        this.result2 = Result.failure((String)"", (Object)this.value, (MarshallingMessage[])new MarshallingMessage[]{this.message2});
        this.result3 = Result.ignored((String)"", (Object)this.value, (MarshallingMessage[])new MarshallingMessage[]{this.message3});
    }

    @Test
    public void compose() {
        Result result = ResultComposer.compose((Object)this.value, (Result[])new Result[]{this.result1, this.result2, this.result3});
        this.assertResult(result);
    }

    private void assertResult(Result result) {
        Assert.assertEquals((long)3L, (long)result.messages().size());
        Assert.assertTrue((boolean)result.messages().stream().anyMatch(arg_0 -> ((MarshallingMessage)this.message1).equals(arg_0)));
        Assert.assertTrue((boolean)result.messages().stream().anyMatch(arg_0 -> ((MarshallingMessage)this.message2).equals(arg_0)));
        Assert.assertTrue((boolean)result.messages().stream().anyMatch(arg_0 -> ((MarshallingMessage)this.message3).equals(arg_0)));
    }

    @Test
    public void composeList() {
        Result result = ResultComposer.compose((Object)this.value, (Collection[])new Collection[]{Arrays.asList(this.result1, this.result2, this.result3)});
        this.assertResult(result);
    }
}

