/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.HashSet;
import java.util.List;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.impl.PropertyImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.InitializedVariable;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.ParsedAssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.FlatVariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ParsedAssignmentsInfoTest {
    private static final String ASSIGNMENTS_INFO = "Years of Service:Integer||Data Test:Boolean||[din]Years of Service=35,[dout]Data Test->BooleanTest";
    private static final String ASSIGNMENTS_INFO_DUPLICATE = "Years of Service:Integer||Data Test:Boolean||[din]Years of Service=35,[dout]Data Test->BooleanTest,[dout]Data Test->BooleanTest2";
    private static final String ASSIGNMENTS_INFO_NO_ASSOCIATION = "||Data Test||";
    private ParsedAssignmentsInfo tested;
    private ParsedAssignmentsInfo testedDuplicates;
    private ParsedAssignmentsInfo testedNoAssociation;

    @Before
    public void setup() {
        AssignmentsInfo assignmentsInfos = new AssignmentsInfo(ASSIGNMENTS_INFO);
        AssignmentsInfo assignmentsInfosDuplicates = new AssignmentsInfo(ASSIGNMENTS_INFO_DUPLICATE);
        AssignmentsInfo assignmentNoAssociation = new AssignmentsInfo(ASSIGNMENTS_INFO_NO_ASSOCIATION);
        this.tested = ParsedAssignmentsInfo.of((AssignmentsInfo)assignmentsInfos);
        this.testedDuplicates = ParsedAssignmentsInfo.of((AssignmentsInfo)assignmentsInfosDuplicates);
        this.testedNoAssociation = ParsedAssignmentsInfo.of((AssignmentsInfo)assignmentNoAssociation);
    }

    @Test
    public void testCreateInitializedInputVariables() {
        String DATA_INPUT_ID = "_Years-of-ServiceInputX";
        String DATA_INPUT_NAME = "Years of Service";
        String DATA_INPUT_ASSOCIATION_ID = "Years of Service";
        String DATA_INPUT_ASSOCIATION_VALUE = "<![CDATA[35]]>";
        String INIT_INPUT_VAR_ID = "Years-of-Service";
        String INIT_INPUT_VAR_TYPE = "Integer";
        FlatVariableScope variableScope = new FlatVariableScope();
        List initializedInputVariables = this.tested.createInitializedInputVariables("", (VariableScope)variableScope, new HashSet());
        Assert.assertEquals((long)1L, (long)initializedInputVariables.size());
        InitializedVariable.InitializedInputVariable initializedInputVariable = (InitializedVariable.InitializedInputVariable)initializedInputVariables.get(0);
        DataInput dataInput = initializedInputVariable.getDataInput();
        DataInputAssociation dataInputAssociation = initializedInputVariable.getDataInputAssociation();
        DataInput target = (DataInput)dataInputAssociation.getTargetRef();
        List assignments = dataInputAssociation.getAssignment();
        Assignment assignment = (Assignment)assignments.get(0);
        FormalExpression from = (FormalExpression)assignment.getFrom();
        String dataInputID = dataInput.getId();
        String dataInputName = dataInput.getName();
        String dataInputAssociationID = target.getName();
        String dataInputAssociationValue = from.getBody();
        String initVarID = initializedInputVariable.getIdentifier();
        String initVarType = initializedInputVariable.getType();
        Assert.assertEquals((Object)dataInputID, (Object)"_Years-of-ServiceInputX");
        Assert.assertEquals((Object)dataInputName, (Object)"Years of Service");
        Assert.assertEquals((Object)dataInputAssociationID, (Object)"Years of Service");
        Assert.assertEquals((Object)dataInputAssociationValue, (Object)"<![CDATA[35]]>");
        Assert.assertEquals((Object)initVarID, (Object)"Years-of-Service");
        Assert.assertEquals((Object)initVarType, (Object)"Integer");
    }

    @Test
    public void testCreateInitializedOutputVariables() {
        String DATA_OUTPUT_ID = "_Data-TestOutputX";
        String DATA_OUTPUT_NAME = "Data Test";
        String DATA_OUTPUT_ASSOCIATION_ID = "Data Test";
        String DATA_OUTPUT_ASSOCIATION_VALUE = "BooleanTest";
        String INIT_OUTPUT_VAR_ID = "Data-Test";
        String INIT_OUTPUT_VAR_TYPE = "Boolean";
        FlatVariableScope variableScope = new FlatVariableScope();
        variableScope.declare("", "BooleanTest", "Boolean");
        List initializedOutputVariables = this.tested.createInitializedOutputVariables("", (VariableScope)variableScope, new HashSet());
        Assert.assertEquals((long)1L, (long)initializedOutputVariables.size());
        InitializedVariable.InitializedOutputVariable initializedOutputVariable = (InitializedVariable.InitializedOutputVariable)initializedOutputVariables.get(0);
        DataOutput dataOuput = initializedOutputVariable.getDataOutput();
        DataOutputAssociation dataOutputAssociation = initializedOutputVariable.getDataOutputAssociation();
        List sourceRef = dataOutputAssociation.getSourceRef();
        DataOutput source = (DataOutput)sourceRef.get(0);
        PropertyImpl target = (PropertyImpl)dataOutputAssociation.getTargetRef();
        String dataOuputID = dataOuput.getId();
        String dataOutputName = dataOuput.getName();
        String dataOutputAssociationID = source.getName();
        String dataOutputAssocationValue = target.getId();
        String initVarID = initializedOutputVariable.getIdentifier();
        String initVarType = initializedOutputVariable.getType();
        Assert.assertEquals((Object)dataOuputID, (Object)"_Data-TestOutputX");
        Assert.assertEquals((Object)dataOutputName, (Object)"Data Test");
        Assert.assertEquals((Object)dataOutputAssociationID, (Object)"Data Test");
        Assert.assertEquals((Object)dataOutputAssocationValue, (Object)"BooleanTest");
        Assert.assertEquals((Object)initVarID, (Object)"Data-Test");
        Assert.assertEquals((Object)initVarType, (Object)"Boolean");
    }

    @Test
    public void testCreateInitializedOutputVariablesNoAssociation() {
        String DATA_OUTPUT_ID = "_Data-TestOutputX";
        String DATA_OUTPUT_NAME = "Data Test";
        String INIT_OUTPUT_VAR_ID = "Data-Test";
        FlatVariableScope variableScope = new FlatVariableScope();
        List initializedOutputVariables = this.testedNoAssociation.createInitializedOutputVariables("", (VariableScope)variableScope, new HashSet());
        Assert.assertEquals((long)1L, (long)initializedOutputVariables.size());
        InitializedVariable.InitializedOutputVariable initializedOutputVariable = (InitializedVariable.InitializedOutputVariable)initializedOutputVariables.get(0);
        DataOutput dataOuput = initializedOutputVariable.getDataOutput();
        DataOutputAssociation dataOutputAssociation = initializedOutputVariable.getDataOutputAssociation();
        String dataOuputID = dataOuput.getId();
        String dataOutputName = dataOuput.getName();
        String initVarID = initializedOutputVariable.getIdentifier();
        Assert.assertNull((Object)dataOutputAssociation);
        Assert.assertEquals((Object)dataOuputID, (Object)"_Data-TestOutputX");
        Assert.assertEquals((Object)dataOutputName, (Object)"Data Test");
        Assert.assertEquals((Object)initVarID, (Object)"Data-Test");
    }

    @Test
    public void testCreateInitializedOutputVariablesDuplicates() {
        String DATA_OUTPUT_ID = "_Data-TestOutputX";
        String DATA_OUTPUT_NAME = "Data Test";
        String DATA_OUTPUT_ASSOCIATION_ID = "Data Test";
        String DATA_OUTPUT_ASSOCIATION_VALUE_1 = "BooleanTest";
        String DATA_OUTPUT_ASSOCIATION_VALUE_2 = "BooleanTest2";
        String INIT_OUTPUT_VAR_ID = "Data-Test";
        String INIT_OUTPUT_VAR_TYPE = "Boolean";
        FlatVariableScope variableScope = new FlatVariableScope();
        variableScope.declare("", "BooleanTest", "Boolean");
        variableScope.declare("", "BooleanTest2", "Boolean");
        List initializedOutputVariables = this.testedDuplicates.createInitializedOutputVariables("", (VariableScope)variableScope, new HashSet());
        Assert.assertEquals((long)2L, (long)initializedOutputVariables.size());
        InitializedVariable.InitializedOutputVariable initializedOutputVariable1 = (InitializedVariable.InitializedOutputVariable)initializedOutputVariables.get(0);
        DataOutput dataOuput1 = initializedOutputVariable1.getDataOutput();
        DataOutputAssociation dataOutputAssociation1 = initializedOutputVariable1.getDataOutputAssociation();
        List sourceRef1 = dataOutputAssociation1.getSourceRef();
        DataOutput source1 = (DataOutput)sourceRef1.get(0);
        PropertyImpl target1 = (PropertyImpl)dataOutputAssociation1.getTargetRef();
        String dataOuputID1 = dataOuput1.getId();
        String dataOutputName1 = dataOuput1.getName();
        String dataOutputAssociationID1 = source1.getName();
        String dataOutputAssocationValue1 = target1.getId();
        String initVarID1 = initializedOutputVariable1.getIdentifier();
        String initVarType1 = initializedOutputVariable1.getType();
        Assert.assertEquals((Object)dataOuputID1, (Object)"_Data-TestOutputX");
        Assert.assertEquals((Object)dataOutputName1, (Object)"Data Test");
        Assert.assertEquals((Object)dataOutputAssociationID1, (Object)"Data Test");
        Assert.assertEquals((Object)dataOutputAssocationValue1, (Object)"BooleanTest");
        Assert.assertEquals((Object)initVarID1, (Object)"Data-Test");
        Assert.assertEquals((Object)initVarType1, (Object)"Boolean");
        InitializedVariable.InitializedOutputVariable initializedOutputVariable2 = (InitializedVariable.InitializedOutputVariable)initializedOutputVariables.get(1);
        DataOutput dataOuput2 = initializedOutputVariable2.getDataOutput();
        DataOutputAssociation dataOutputAssociation2 = initializedOutputVariable2.getDataOutputAssociation();
        List sourceRef2 = dataOutputAssociation2.getSourceRef();
        DataOutput source2 = (DataOutput)sourceRef2.get(0);
        PropertyImpl target2 = (PropertyImpl)dataOutputAssociation2.getTargetRef();
        String dataOuputID2 = dataOuput2.getId();
        String dataOutputName2 = dataOuput2.getName();
        String dataOutputAssociationID2 = source2.getName();
        String dataOutputAssocationValue2 = target2.getId();
        String initVarID2 = initializedOutputVariable2.getIdentifier();
        String initVarType2 = initializedOutputVariable2.getType();
        Assert.assertEquals((Object)dataOuputID2, (Object)"_Data-TestOutputX");
        Assert.assertEquals((Object)dataOutputName2, (Object)"Data Test");
        Assert.assertEquals((Object)dataOutputAssociationID2, (Object)"Data Test");
        Assert.assertEquals((Object)dataOutputAssocationValue2, (Object)"BooleanTest2");
        Assert.assertEquals((Object)initVarID2, (Object)"Data-Test");
        Assert.assertEquals((Object)initVarType2, (Object)"Boolean");
    }

    @Test
    public void fromString() {
        String original = "|input1:String,input2:String||output1:String,output2:String|[din]pv1->input1,[din]pv2->input2,[dout]output1->pv2,[dout]output2->pv2";
        this.assertParseUnparse(original);
    }

    @Test
    public void fromString2() {
        String original = "||IntermediateMessageEventCatchingOutputVar1:String||[dout]IntermediateMessageEventCatchingOutputVar1->var1";
        this.assertParseUnparse(original);
    }

    private void assertParseUnparse(String original) {
        ParsedAssignmentsInfo assignmentsInfo = ParsedAssignmentsInfo.fromString((String)original);
        String s1 = assignmentsInfo.toString();
        String s2 = ParsedAssignmentsInfo.fromString((String)s1).toString();
        Assert.assertEquals((Object)original, (Object)s2);
    }
}

