/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.ParsedNotificationsInfos;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.associations.AssociationType;
import org.kie.workbench.common.stunner.bpmn.definition.property.notification.NotificationValue;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ParsedNotificationsInfosTest {
    @Test
    public void testNotification() {
        String body = "[from:director|tousers:director,jack,katy|togroups:Forms,IT|replyTo:guest|subject:asd|body:asd]@[11h]";
        NotificationValue actual = ParsedNotificationsInfos.of((String)AssociationType.NOT_COMPLETED_NOTIFY.getName(), (String)body);
        NotificationValue expected = new NotificationValue();
        expected.setType(AssociationType.NOT_COMPLETED_NOTIFY.getName());
        expected.setFrom("director");
        expected.setReplyTo("guest");
        expected.setSubject("asd");
        expected.setBody("asd");
        expected.setExpiresAt("11h");
        expected.setGroups(new ArrayList<String>(Arrays.asList("Forms", "IT")));
        expected.setUsers(new ArrayList<String>(Arrays.asList("director", "jack", "katy")));
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNotificationPartial() {
        String body = "[from:|tousers:|togroups:|replyTo:|subject:|body:]@[0h]";
        NotificationValue actual = ParsedNotificationsInfos.of((String)AssociationType.NOT_COMPLETED_NOTIFY.getName(), (String)body);
        NotificationValue expected = new NotificationValue();
        expected.setType(AssociationType.NOT_COMPLETED_NOTIFY.getName());
        expected.setExpiresAt("0h");
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
        Assert.assertEquals((Object)expected.toCDATAFormat(), (Object)actual.toCDATAFormat());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNotificationPartialVerticalBar() {
        String body = "[from:|tousers:|togroups:|replyTo:|subject:ZZZ&#124;ZZZ&#124;ZZZ&#124;|body:asd&#124;&#124;&#124;asd]@[0h]";
        NotificationValue actual = ParsedNotificationsInfos.of((String)AssociationType.NOT_COMPLETED_NOTIFY.getName(), (String)body);
        NotificationValue expected = new NotificationValue();
        expected.setType(AssociationType.NOT_COMPLETED_NOTIFY.getName());
        expected.setExpiresAt("0h");
        expected.setBody("asd|||asd");
        expected.setSubject("ZZZ|ZZZ|ZZZ|");
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
        Assert.assertEquals((Object)expected.toCDATAFormat(), (Object)actual.toCDATAFormat());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNotificationPartialVerticalBarBadFormat() {
        String bodyError = "[from:|tousers:|togroups:|replyTo:|subject:ZZZ&#124;ZZZ&#124;ZZZ&#124;|body:asd&#124;&#124;&#124;asd]@[0h]]";
        NotificationValue actualError = ParsedNotificationsInfos.of((String)AssociationType.NOT_COMPLETED_NOTIFY.getName(), (String)bodyError);
        NotificationValue unexpected = new NotificationValue();
        unexpected.setType(AssociationType.NOT_COMPLETED_NOTIFY.getName());
        unexpected.setExpiresAt("0h");
        unexpected.setBody("asd|||asd");
        unexpected.setSubject("ZZZ|ZZZ|ZZZ|");
        Assert.assertNotEquals((Object)unexpected.toString(), (Object)actualError.toString());
        Assert.assertNotEquals((Object)unexpected.toCDATAFormat(), (Object)actualError.toCDATAFormat());
        Assert.assertNotEquals((Object)unexpected, (Object)actualError);
    }

    @Test
    public void testNotificationPartialVerticalBarPreservingBrackets() {
        String body = "[from:|tousers:|togroups:|replyTo:|subject:|body:test[test]]@[PT1M]";
        NotificationValue actual = ParsedNotificationsInfos.of((String)AssociationType.NOT_COMPLETED_NOTIFY.getName(), (String)body);
        NotificationValue expected = new NotificationValue();
        expected.setType(AssociationType.NOT_COMPLETED_NOTIFY.getName());
        expected.setBody("test[test]");
        expected.setExpiresAt("PT1M");
        Assert.assertEquals((Object)expected.getBody(), (Object)actual.getBody());
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
        Assert.assertEquals((Object)expected.toCDATAFormat(), (Object)actual.toCDATAFormat());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNotificationEmpty() {
        NotificationValue value = ParsedNotificationsInfos.of((String)AssociationType.NOT_COMPLETED_NOTIFY.getName(), (String)"");
        NotificationValue valid = new NotificationValue();
        valid.setType(AssociationType.NOT_COMPLETED_NOTIFY.getName());
        Assert.assertEquals((Object)valid, (Object)value);
    }
}

