/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDefinition;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class Assertions {
    private static int count(String string, String substring) {
        int count = 0;
        int idx = 0;
        while ((idx = string.indexOf(substring, idx)) != -1) {
            ++idx;
            ++count;
        }
        return count;
    }

    public static void assertDiagram(Diagram<Graph, Metadata> diagram, int nodesSize) {
        Assert.assertEquals((long)nodesSize, (long)Assertions.getNodes(diagram).size());
    }

    public static void assertDiagram(String result, int diagramCount, int nodeCount, int edgeCount) {
        int d = Assertions.count(result, "<bpmndi:BPMNDiagram");
        int n = Assertions.count(result, "<bpmndi:BPMNShape");
        int e = Assertions.count(result, "<bpmndi:BPMNEdge");
        Assert.assertEquals((String)"diagram count should match", (long)diagramCount, (long)d);
        Assert.assertEquals((String)"node count should match", (long)nodeCount, (long)n);
        Assert.assertEquals((String)"edge count should match", (long)edgeCount, (long)e);
    }

    public static List<Node> getNodes(Diagram<Graph, Metadata> diagram) {
        Graph graph = diagram.getGraph();
        Assert.assertNotNull((Object)graph);
        Iterator nodesIterable = graph.nodes().iterator();
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodesIterable.forEachRemaining(nodes::add);
        return nodes;
    }

    public static void assertDocumentation(Diagram<Graph, Metadata> diagram, String id, String value) {
        Optional<BPMNDefinition> documentation = Assertions.getNodes(diagram).stream().filter(node -> node.getContent() instanceof View && node.getUUID().equals(id)).map(node -> (View)node.getContent()).filter(view -> view.getDefinition() instanceof BPMNDefinition).map(view -> (BPMNDefinition)view.getDefinition()).findFirst();
        String documentationValue = documentation.isPresent() ? documentation.get().getGeneral().getDocumentation().getValue() : null;
        Assert.assertEquals((Object)value, documentationValue);
    }
}

