/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import org.kie.internal.identity.IdentityProvider;
import org.kie.server.api.security.SecurityAdapter;

public class JACCIdentityProvider
implements IdentityProvider {
    private static final ServiceLoader<SecurityAdapter> securityAdapters = ServiceLoader.load(SecurityAdapter.class);
    private List<SecurityAdapter> adapters = new ArrayList<SecurityAdapter>();

    public JACCIdentityProvider() {
        for (SecurityAdapter adapter : securityAdapters) {
            this.adapters.add(adapter);
        }
    }

    public String getName() {
        Set<Principal> principals;
        Subject subject = this.getSubjectFromContainer();
        if (subject != null && (principals = subject.getPrincipals()) != null) {
            for (Principal principal : principals) {
                if (!this.supportedPrincipal(principal)) continue;
                return principal.getName();
            }
        }
        return this.getNameFromAdapter();
    }

    public List<String> getRoles() {
        Set<Principal> principals;
        ArrayList<String> roles = new ArrayList<String>();
        Subject subject = this.getSubjectFromContainer();
        if (subject != null && (principals = subject.getPrincipals()) != null) {
            roles = new ArrayList();
            for (Principal principal : principals) {
                if (!(principal instanceof Group)) continue;
                Enumeration groups = ((Group)principal).members();
                while (groups.hasMoreElements()) {
                    Principal groupPrincipal = (Principal)groups.nextElement();
                    roles.add(groupPrincipal.getName());
                }
                break block0;
            }
        }
        roles.addAll(this.getRolesFromAdapter());
        return roles;
    }

    public boolean hasRole(String s) {
        Set<Principal> principals;
        Subject subject = this.getSubjectFromContainer();
        if (subject != null && (principals = subject.getPrincipals()) != null) {
            for (Principal principal : principals) {
                if (!(principal instanceof Group)) continue;
                Enumeration groups = ((Group)principal).members();
                while (groups.hasMoreElements()) {
                    Principal groupPrincipal = (Principal)groups.nextElement();
                    if (!groupPrincipal.getName().equals(s)) continue;
                    return true;
                }
                break block0;
            }
        }
        for (SecurityAdapter adapter : this.adapters) {
            List adapterRoles = adapter.getRoles(new Object[0]);
            if (adapterRoles == null || !adapterRoles.contains(s)) continue;
            return true;
        }
        return false;
    }

    protected Subject getSubjectFromContainer() {
        try {
            return (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getNameFromAdapter() {
        for (SecurityAdapter adapter : this.adapters) {
            String name = adapter.getUser(new Object[0]);
            if (name == null || name.isEmpty()) continue;
            return name;
        }
        return "unknown";
    }

    protected List<String> getRolesFromAdapter() {
        ArrayList<String> roles = new ArrayList<String>();
        for (SecurityAdapter adapter : this.adapters) {
            List adapterRoles = adapter.getRoles(new Object[0]);
            if (adapterRoles == null || adapterRoles.isEmpty()) continue;
            roles.addAll(adapterRoles);
        }
        return roles;
    }

    protected boolean supportedPrincipal(Principal principal) {
        return !(principal instanceof Group) && !principal.getClass().getName().endsWith("BasicAuthorizationPrincipal");
    }
}

