/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server.conversion.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.drools.workbench.models.datamodel.rule.ActionFieldList;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.util.FromTo;

public class ColumnContext {
    private int brlActionColumnCount = 0;
    private final List<String> addedInserts = new ArrayList<String>();
    private final Map<BRLColumn, List<FromTo>> map = new HashMap<BRLColumn, List<FromTo>>();
    private final Map<IPattern, List<String>> conditionVariablesByDefinition = new HashMap<IPattern, List<String>>();

    public void put(BRLColumn brlColumn, FromTo childColumn) {
        if (!this.map.containsKey(brlColumn)) {
            this.map.put(brlColumn, new ArrayList());
        }
        this.map.get(brlColumn).add(childColumn);
    }

    public List<FromTo> getCols(BRLColumn baseColumn) {
        return this.map.get(baseColumn);
    }

    public List<String> getVariablesInOrderOfUse(BRLActionColumn brlColumn) {
        ArrayList<String> result = new ArrayList<String>();
        for (IAction iAction : brlColumn.getDefinition()) {
            result.addAll(this.getVariablesInOrderOfUse(iAction));
        }
        return result;
    }

    public List<String> getVariablesInOrderOfUse(IAction iAction) {
        ArrayList<String> result = new ArrayList<String>();
        if (iAction instanceof ActionFieldList) {
            for (ActionFieldValue fieldValue : ((ActionFieldList)iAction).getFieldValues()) {
                if (fieldValue.getNature() != 7) continue;
                String variable = fieldValue.getValue();
                result.add(variable);
            }
        }
        return result;
    }

    public List<String> getVariablesInOrderOfUse(BRLConditionColumn brlColumn) {
        ArrayList<String> result = new ArrayList<String>();
        for (IPattern iPattern : brlColumn.getDefinition()) {
            result.addAll(this.getVariablesInOrderOfUse(iPattern));
        }
        return result;
    }

    public List<String> getVariablesInOrderOfUse(IPattern iPattern) {
        ArrayList<String> result = new ArrayList<String>();
        if (!this.conditionVariablesByDefinition.containsKey(iPattern)) {
            this.conditionVariablesByDefinition.put(iPattern, new ArrayList());
        }
        if (iPattern instanceof FactPattern) {
            this.addBoundName(((FactPattern)iPattern).getBoundName());
            for (FieldConstraint constraint : ((FactPattern)iPattern).getConstraintList().getConstraints()) {
                if (!(constraint instanceof SingleFieldConstraint) || ((SingleFieldConstraint)constraint).getConstraintValueType() != 7) continue;
                String variable = ((SingleFieldConstraint)constraint).getValue();
                result.add(variable);
                this.conditionVariablesByDefinition.get(iPattern).add(variable);
            }
        }
        return result;
    }

    private List<String> getVariables(IPattern iPattern) {
        return this.conditionVariablesByDefinition.get(iPattern);
    }

    public int getAmountOfUniqueVariables(IPattern iPattern) {
        return new HashSet<String>(this.getVariables(iPattern)).size();
    }

    public void addBoundName(String boundName) {
        if (StringUtils.isNotEmpty((CharSequence)boundName)) {
            this.addedInserts.add(boundName);
        }
    }

    public boolean isBoundNameFree(String boundName) {
        return !this.addedInserts.contains(boundName);
    }

    public String getNextFreeColumnFactName() {
        return "brlColumnFact" + this.brlActionColumnCount++;
    }
}

