/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.BasePropertyReader;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.CircleDimensionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.RectangleDimensionsSet;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class BasePropertyReaderTest {
    private static final double RESOLUTION_FACTOR = 0.65;
    @Mock
    private BaseElement element;
    @Mock
    private BPMNShape shape;
    @Mock
    private BPMNDiagram diagram;
    private BasePropertyReader tested;

    @Before
    public void setup() {
        FeatureMap featureMap = (FeatureMap)Mockito.mock(FeatureMap.class);
        Mockito.when((Object)featureMap.isEmpty()).thenReturn((Object)true);
        Mockito.when((Object)this.element.getAnyAttribute()).thenReturn((Object)featureMap);
        Bounds shapeBounds = (Bounds)Mockito.mock(Bounds.class);
        Mockito.when((Object)Float.valueOf(shapeBounds.getX())).thenReturn((Object)Float.valueOf(1.1f));
        Mockito.when((Object)Float.valueOf(shapeBounds.getY())).thenReturn((Object)Float.valueOf(2.2f));
        Mockito.when((Object)Float.valueOf(shapeBounds.getWidth())).thenReturn((Object)Float.valueOf(100.0f));
        Mockito.when((Object)Float.valueOf(shapeBounds.getHeight())).thenReturn((Object)Float.valueOf(545.34f));
        Mockito.when((Object)this.shape.getBounds()).thenReturn((Object)shapeBounds);
        this.tested = new BasePropertyReader(this.element, this.diagram, this.shape, 0.65);
    }

    @Test
    public void testBounds() {
        org.kie.workbench.common.stunner.core.graph.content.Bounds bounds = this.tested.getBounds();
        Assert.assertTrue((boolean)bounds.hasLowerRight());
        Assert.assertTrue((boolean)bounds.hasUpperLeft());
        Assert.assertEquals((double)0.7150000154972077, (double)bounds.getUpperLeft().getX(), (double)0.0);
        Assert.assertEquals((double)1.4300000309944154, (double)bounds.getUpperLeft().getY(), (double)0.0);
        Assert.assertEquals((double)65.71500001549721, (double)bounds.getLowerRight().getX(), (double)0.0);
        Assert.assertEquals((double)355.9010174870491, (double)bounds.getLowerRight().getY(), (double)0.0);
    }

    @Test
    public void testGetCircleDimensionSet() {
        CircleDimensionSet circleDimensionSet = this.tested.getCircleDimensionSet();
        Assert.assertEquals((double)32.5, (double)circleDimensionSet.getRadius().getValue(), (double)0.0);
    }

    @Test
    public void testGetRectangleDimensionsSet() {
        RectangleDimensionsSet rectangleDimensionsSet = this.tested.getRectangleDimensionsSet();
        Assert.assertEquals((double)65.0, (double)rectangleDimensionsSet.getWidth().getValue(), (double)0.0);
        Assert.assertEquals((double)354.4710174560547, (double)rectangleDimensionsSet.getHeight().getValue(), (double)0.0);
    }

    @Test
    public void testIsExpandedTrue() {
        Mockito.when((Object)this.shape.isIsExpanded()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.tested.isExpanded());
    }

    @Test
    public void testIsExpandedFalse() {
        Mockito.when((Object)this.shape.isIsExpanded()).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.shape.isIsExpanded());
    }

    @Test
    public void testGetElement() {
        Assert.assertEquals((Object)this.element, (Object)this.tested.getElement());
    }

    @Test
    public void testGetShape() {
        Assert.assertEquals((Object)this.shape, (Object)this.tested.getShape());
    }
}

