/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events;

import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.StartEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.StartMessageEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseStartEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.InterruptingMessageEventExecutionSet;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class StartMessageEventTest
extends StartEventTest<StartMessageEvent> {
    private static final String BPMN_START_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/messageStartEvents.bpmn";
    private static final String FILLED_TOP_LEVEL_EVENT_ID = "2B967C25-C1FE-4945-8511-7A9E5465BA22";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "D78124CD-19B0-45C6-AF0A-CD7C16F4F3BD";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_ID = "464FB8BC-F752-4428-A3DC-D5DDCEE2353F";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "372D12E1-30F9-4504-8ED5-5F7D1735FEDB";
    private static final String SLA_DUE_DATE = "12/25/1983";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 11;

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Message message name ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String EVENT_DOCUMENTATION = "Message documentation\n~`!@#$%^&*()_+=-{}|\\][:\";'?><,./\n";
        String EVENT_REF = "Message1";
        String EVENT_DATA_OUTPUT = "||messageReceived:String||[dout]messageReceived->helloProcess";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 11);
        StartMessageEvent filledTop = (StartMessageEvent)this.getStartNodeById(diagram, FILLED_TOP_LEVEL_EVENT_ID);
        this.assertGeneralSet(filledTop.getGeneral(), "Message message name ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./", "Message documentation\n~`!@#$%^&*()_+=-{}|\\][:\";'?><,./\n");
        this.assertMessageEventExecutionSet(filledTop.getExecutionSet(), "Message1", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledTop.getDataIOSet(), "||messageReceived:String||[dout]messageReceived->helloProcess");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 11);
        StartMessageEvent emptyTop = (StartMessageEvent)this.getStartNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID);
        this.assertGeneralSet(emptyTop.getGeneral(), "", "");
        this.assertMessageEventExecutionSet(emptyTop.getExecutionSet(), "", false, "");
        this.assertDataIOSet(emptyTop.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Message name ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String EVENT_DOCUMENTATION = "Doc is here\n~`!@#$%^&*()_+=-{}|\\][:\";'?><,./\n";
        String EVENT_REF = "Message2";
        String EVENT_DATA_OUTPUT = "||messageR:String||[dout]messageR->helloProcess";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 11);
        StartMessageEvent filledSubprocess = (StartMessageEvent)this.getStartNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_ID);
        this.assertGeneralSet(filledSubprocess.getGeneral(), "Message name ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./", "Doc is here\n~`!@#$%^&*()_+=-{}|\\][:\";'?><,./\n");
        this.assertMessageEventExecutionSet(filledSubprocess.getExecutionSet(), "Message2", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocess.getDataIOSet(), "||messageR:String||[dout]messageR->helloProcess");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 11);
        StartMessageEvent emptySubprocess = (StartMessageEvent)this.getStartNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID);
        this.assertGeneralSet(emptySubprocess.getGeneral(), "", "");
        this.assertMessageEventExecutionSet(emptySubprocess.getExecutionSet(), "", false, "");
        this.assertDataIOSet(emptySubprocess.getDataIOSet(), "");
    }

    @Override
    String getBpmnStartEventFilePath() {
        return BPMN_START_EVENT_FILE_PATH;
    }

    @Override
    String getFilledTopLevelEventId() {
        return FILLED_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventId() {
        return FILLED_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    Class<StartMessageEvent> getStartEventType() {
        return StartMessageEvent.class;
    }

    private void assertMessageEventExecutionSet(InterruptingMessageEventExecutionSet executionSet, String eventName, boolean isInterrupting, String slaDueDate) {
        Assert.assertNotNull((Object)executionSet);
        Assert.assertNotNull((Object)executionSet.getMessageRef());
        Assert.assertEquals((Object)eventName, (Object)executionSet.getMessageRef().getValue());
        this.assertStartEventIsInterrupting((BaseStartEventExecutionSet)executionSet, isInterrupting);
        this.assertStartEventSlaDueDate((BaseStartEventExecutionSet)executionSet, slaDueDate);
    }
}

