/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector;

import java.util.Random;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.Selector;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleSupport;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSelector
implements Selector {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected PhaseLifecycleSupport phaseLifecycleSupport = new PhaseLifecycleSupport();
    protected Random workingRandom = null;

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        this.workingRandom = solverScope.getWorkingRandom();
        this.phaseLifecycleSupport.fireSolvingStarted(solverScope);
    }

    public void phaseStarted(AbstractPhaseScope phaseScope) {
        this.phaseLifecycleSupport.firePhaseStarted(phaseScope);
    }

    public void stepStarted(AbstractStepScope stepScope) {
        this.phaseLifecycleSupport.fireStepStarted(stepScope);
    }

    public void stepEnded(AbstractStepScope stepScope) {
        this.phaseLifecycleSupport.fireStepEnded(stepScope);
    }

    public void phaseEnded(AbstractPhaseScope phaseScope) {
        this.phaseLifecycleSupport.firePhaseEnded(phaseScope);
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        this.phaseLifecycleSupport.fireSolvingEnded(solverScope);
        this.workingRandom = null;
    }

    @Override
    public SelectionCacheType getCacheType() {
        return SelectionCacheType.JUST_IN_TIME;
    }
}

