/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.definition.adapter.binding;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionId;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterFunctions;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableDefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.DefinitionAdapterBindings;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.DefinitionBindableProperty;
import org.kie.workbench.common.stunner.core.definition.property.PropertyMetaTypes;
import org.kie.workbench.common.stunner.core.factory.graph.ElementFactory;
import org.kie.workbench.common.stunner.core.i18n.StunnerTranslationService;

public class BindableDefinitionAdapterImpl<T>
implements BindableDefinitionAdapter<T> {
    private final StunnerTranslationService translationService;
    private final BindableAdapterFunctions functions;
    private final Map<Class<?>, DefinitionAdapterBindings> bindings;

    public static BindableDefinitionAdapterImpl<Object> create(StunnerTranslationService translationService, BindableAdapterFunctions functions) {
        return BindableDefinitionAdapterImpl.create(translationService, functions, new HashMap());
    }

    public static BindableDefinitionAdapterImpl<Object> create(StunnerTranslationService translationService, BindableAdapterFunctions functions, Map<Class<?>, DefinitionAdapterBindings> bindings) {
        return new BindableDefinitionAdapterImpl<Object>(translationService, functions, bindings);
    }

    private BindableDefinitionAdapterImpl(StunnerTranslationService translationService, BindableAdapterFunctions functions, Map<Class<?>, DefinitionAdapterBindings> bindings) {
        this.translationService = translationService;
        this.functions = functions;
        this.bindings = bindings;
    }

    public void addBindings(Class<?> type, DefinitionAdapterBindings bindings) {
        this.bindings.put(type, bindings);
    }

    public DefinitionId getId(T pojo) {
        String fieldId = this.getBindings(pojo).getIdField();
        String definitionId = BindableDefinitionAdapterImpl.getDefinitionId(pojo.getClass());
        if (null != fieldId) {
            String id = BindableAdapterUtils.getDynamicDefinitionId((String)definitionId, (String)((String)this.getFieldValue(pojo, fieldId)));
            return DefinitionId.build((String)id, (int)definitionId.length());
        }
        return DefinitionId.build((String)definitionId);
    }

    public String getCategory(T pojo) {
        return (String)this.getFieldValue(pojo, this.bindings.get(pojo.getClass()).getCategoryField());
    }

    public String getTitle(T pojo) {
        String title = (String)this.getFieldValue(pojo, this.bindings.get(pojo.getClass()).getTitleField());
        if (BindableDefinitionAdapterImpl.isEmpty(title)) {
            return this.translationService.getDefinitionTitle(pojo.getClass().getName());
        }
        return title;
    }

    public String getDescription(T pojo) {
        String description = (String)this.getFieldValue(pojo, this.bindings.get(pojo.getClass()).getDescriptionField());
        if (BindableDefinitionAdapterImpl.isEmpty(description)) {
            return this.translationService.getDefinitionDescription(pojo.getClass().getName());
        }
        return description;
    }

    public String[] getLabels(T pojo) {
        String fName = this.bindings.get(pojo.getClass()).getLabelsField();
        Object labels = this.getFieldValue(pojo, fName);
        if (labels instanceof Collection) {
            Collection labelsCollection = (Collection)labels;
            return labelsCollection.toArray(new String[labelsCollection.size()]);
        }
        return null != labels ? (String[])labels : new String[]{};
    }

    public String[] getPropertyFields(T pojo) {
        List fields = this.bindings.get(pojo.getClass()).getPropertiesFieldNames();
        return null != fields ? fields.toArray(new String[fields.size()]) : new String[]{};
    }

    public Optional<?> getProperty(T pojo, String field) {
        DefinitionAdapterBindings b = this.bindings.get(pojo.getClass());
        int index = b.getPropertiesFieldNames().indexOf(field);
        Boolean isTyped = (Boolean)b.getTypedPropertyFields().get(index);
        return isTyped != false ? Optional.ofNullable(this.getFieldValue(pojo, field)) : Optional.of(new DefinitionBindableProperty(pojo, field));
    }

    public String getMetaPropertyField(T pojo, PropertyMetaTypes type) {
        int index = this.bindings.get(pojo.getClass()).getMetaTypes().getIndex(type);
        return index > -1 ? this.getPropertyFields(pojo)[index] : null;
    }

    public String getBaseType(Class<?> type) {
        Class baseType = this.bindings.get(type).getBaseType();
        if (null != baseType) {
            return BindableDefinitionAdapterImpl.getDefinitionId(baseType);
        }
        return null;
    }

    public String[] getTypes(String baseType) {
        LinkedList result = new LinkedList();
        this.bindings.forEach((type, defBindings) -> {
            Class _baseType = defBindings.getBaseType();
            String _id = BindableDefinitionAdapterImpl.getDefinitionId(_baseType);
            if (baseType.equals(_id)) {
                result.add(BindableDefinitionAdapterImpl.getDefinitionId(type));
            }
        });
        if (!result.isEmpty()) {
            return result.toArray(new String[result.size()]);
        }
        return null;
    }

    public Class<? extends ElementFactory> getGraphFactoryType(T pojo) {
        return this.getGraphFactory(pojo.getClass());
    }

    public Class<? extends ElementFactory> getGraphFactory(Class<?> type) {
        return this.bindings.get(type).getGraphFactory();
    }

    private DefinitionAdapterBindings getBindings(T pojo) {
        return this.bindings.get(pojo.getClass());
    }

    public boolean accepts(Class<?> type) {
        boolean hasType = this.bindings.containsKey(type);
        return hasType || this.bindings.values().stream().map(DefinitionAdapterBindings::getBaseType).anyMatch(t -> t.equals(type));
    }

    public int getPriority() {
        return 0;
    }

    private <R> R getFieldValue(T pojo, String field) {
        return (R)this.functions.getValue(pojo, field);
    }

    private static String getDefinitionId(Class<?> type) {
        return BindableAdapterUtils.getDefinitionId(type);
    }

    private static boolean isEmpty(String s) {
        return null == s || s.trim().length() == 0;
    }
}

