/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.rule.handler.impl;

import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.rule.RuleEvaluationHandler;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;
import org.kie.workbench.common.stunner.core.rule.context.GraphConnectionContext;
import org.kie.workbench.common.stunner.core.rule.context.GraphEvaluationState;
import org.kie.workbench.common.stunner.core.rule.context.impl.RuleEvaluationContextBuilder;
import org.kie.workbench.common.stunner.core.rule.handler.impl.ConnectionEvaluationHandler;
import org.kie.workbench.common.stunner.core.rule.handler.impl.GraphEvaluationHandlerUtils;
import org.kie.workbench.common.stunner.core.rule.impl.CanConnect;
import org.kie.workbench.common.stunner.core.rule.violations.DefaultRuleViolations;

@ApplicationScoped
public class GraphConnectionEvaluationHandler
implements RuleEvaluationHandler<CanConnect, GraphConnectionContext> {
    private final ConnectionEvaluationHandler connectionEvaluationHandler;
    private final GraphEvaluationHandlerUtils evalUtils;

    protected GraphConnectionEvaluationHandler() {
        this(null, null);
    }

    @Inject
    public GraphConnectionEvaluationHandler(DefinitionManager definitionManager, ConnectionEvaluationHandler connectionEvaluationHandler) {
        this.connectionEvaluationHandler = connectionEvaluationHandler;
        this.evalUtils = new GraphEvaluationHandlerUtils(definitionManager);
    }

    public Class<CanConnect> getRuleType() {
        return CanConnect.class;
    }

    public Class<GraphConnectionContext> getContextType() {
        return GraphConnectionContext.class;
    }

    public boolean accepts(CanConnect rule, GraphConnectionContext context) {
        Edge connector = context.getConnector();
        Set<String> labels = this.evalUtils.getLabels((Element<? extends Definition<?>>)connector);
        return labels.stream().filter(cr -> rule.getRole().equals(cr) && this.connectionEvaluationHandler.accepts(rule, RuleEvaluationContextBuilder.DomainContexts.connection(cr, Optional.empty(), Optional.empty()))).findAny().isPresent();
    }

    public RuleViolations evaluate(CanConnect rule, GraphConnectionContext context) {
        GraphEvaluationState.ConnectionState connectionState = context.getState().getConnectionState();
        Edge connector = context.getConnector();
        Node source = context.getSource().orElse(connectionState.getSource(connector));
        Node target = context.getTarget().orElse(connectionState.getTarget(connector));
        if (source == null || target == null) {
            return new DefaultRuleViolations();
        }
        Set<String> edgeLabels = this.evalUtils.getLabels((Element<? extends Definition<?>>)connector);
        Optional<Set<String>> sourceLabels = Optional.of(this.evalUtils.getLabels((Element<? extends Definition<?>>)source));
        Optional<Set<String>> targetLabels = Optional.of(this.evalUtils.getLabels((Element<? extends Definition<?>>)target));
        DefaultRuleViolations result = new DefaultRuleViolations();
        edgeLabels.stream().filter(pr -> rule.getRole().equals(pr)).forEach(pr -> result.addViolations(this.connectionEvaluationHandler.evaluate(rule, RuleEvaluationContextBuilder.DomainContexts.connection(pr, sourceLabels, targetLabels))));
        return GraphEvaluationHandlerUtils.addViolationsSourceUUID(connector.getUUID(), result);
    }
}

