/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.openshift.impl.storage.cloud;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieServerConfigItem;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.impl.storage.KieServerStateRepository;
import org.kie.server.services.openshift.impl.storage.cloud.CloudClientFactory;
import org.kie.soup.xstream.XStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KieServerStateCloudRepository
implements KieServerStateRepository,
CloudClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(KieServerStateCloudRepository.class);
    protected final XStream xs = KieServerStateCloudRepository.initializeXStream();

    public static XStream initializeXStream() {
        XStream xs = XStreamUtils.createTrustingXStream((ReflectionProvider)new PureJavaReflectionProvider());
        String[] voidDeny = new String[]{"void.class", "Void.class"};
        xs.denyTypes(voidDeny);
        xs.alias("kie-server-state", KieServerState.class);
        xs.alias("container", KieContainerResource.class);
        xs.alias("config-item", KieServerConfigItem.class);
        return xs;
    }

    protected String retrieveKieServerId(KieServerState kieServerState) {
        String kssServerId = null;
        try {
            kssServerId = kieServerState.getConfiguration().getConfigItemValue("org.kie.server.id");
        }
        catch (Exception e) {
            logger.error("Failed to retrieve server id from KieServerState", (Throwable)e);
        }
        if (kssServerId == null || kssServerId.length() == 0) {
            throw new IllegalArgumentException("Invalid KieServerId: Can not be null or empty.");
        }
        return kssServerId;
    }
}

