/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.junit.jupiter;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Optional;
import java.util.function.Consumer;
import org.assertj.core.api.BDDSoftAssertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.annotation.Testable;
import org.junit.platform.commons.support.AnnotationSupport;

public class SoftAssertionsExtension
implements ParameterResolver,
AfterTestExecutionCallback {
    private static final ExtensionContext.Namespace SOFT_ASSERTIONS_EXTENSION_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{SoftAssertionsExtension.class});

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        boolean isTestableMethod;
        if (SoftAssertionsExtension.isUnsupportedParameterType(parameterContext.getParameter())) {
            return false;
        }
        Executable executable = parameterContext.getDeclaringExecutable();
        boolean bl = isTestableMethod = executable instanceof Method && AnnotationSupport.isAnnotated((AnnotatedElement)executable, Testable.class);
        if (!isTestableMethod) {
            throw new ParameterResolutionException(String.format("Configuration error: cannot resolve SoftAssertions or BDDSoftAssertions for [%s]. Only test methods are supported.", executable));
        }
        return true;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return SoftAssertionsExtension.getStore(extensionContext).getOrComputeIfAbsent(parameterContext.getParameter().getType());
    }

    public void afterTestExecution(ExtensionContext extensionContext) {
        SoftAssertionsExtension.assertAll(extensionContext, SoftAssertions.class, SoftAssertions::assertAll);
        SoftAssertionsExtension.assertAll(extensionContext, BDDSoftAssertions.class, BDDSoftAssertions::assertAll);
    }

    private static <T> void assertAll(ExtensionContext extensionContext, Class<T> type, Consumer<T> assertAll) {
        Optional.ofNullable(SoftAssertionsExtension.getStore(extensionContext).remove(type, type)).ifPresent(assertAll);
    }

    private static boolean isUnsupportedParameterType(Parameter parameter) {
        Class<?> type = parameter.getType();
        return type != SoftAssertions.class && type != BDDSoftAssertions.class;
    }

    private static ExtensionContext.Store getStore(ExtensionContext extensionContext) {
        return extensionContext.getStore(SOFT_ASSERTIONS_EXTENSION_NAMESPACE);
    }
}

