/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.service;

import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSourceDefDeployer;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSourceRuntimeManager;
import org.kie.workbench.common.screens.datasource.management.backend.core.DeploymentOptions;
import org.kie.workbench.common.screens.datasource.management.backend.service.AbstractDefDeployer;
import org.kie.workbench.common.screens.datasource.management.backend.service.DefRegistry;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDef;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDefInfo;
import org.kie.workbench.common.screens.datasource.management.service.DataSourceDefQueryService;
import org.kie.workbench.common.screens.datasource.management.util.DataSourceDefSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;

@ApplicationScoped
public class DataSourceDefDeployerImpl
extends AbstractDefDeployer<DataSourceDefInfo>
implements DataSourceDefDeployer {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceDefDeployerImpl.class);

    public DataSourceDefDeployerImpl() {
    }

    @Inject
    public DataSourceDefDeployerImpl(@Named(value="ioStrategy") IOService ioService, DataSourceDefQueryService queryService, DataSourceRuntimeManager runtimeManager, DefRegistry defRegistry) {
        super(ioService, queryService, runtimeManager, defRegistry);
    }

    @Override
    protected Collection<DataSourceDefInfo> findGlobalDefs() {
        return this.queryService.findGlobalDataSources(false);
    }

    @Override
    protected Collection<DataSourceDefInfo> findProjectDefs(Path path) {
        return this.queryService.findModuleDataSources(path);
    }

    @Override
    protected void deployDef(DataSourceDefInfo defInfo) {
        try {
            logger.debug("Deploying data source def: " + defInfo);
            String source = this.ioService.readAllString(Paths.convert((Path)defInfo.getPath()));
            DataSourceDef dataSourceDef = DataSourceDefSerializer.deserialize(source);
            this.runtimeManager.deployDataSource(dataSourceDef, DeploymentOptions.createOrResync());
            this.defRegistry.setEntry(defInfo.getPath(), dataSourceDef);
            logger.debug("Data source was successfully deployed");
        }
        catch (Exception e) {
            logger.error("Data source deployment failed, defInfo: " + defInfo, (Throwable)e);
        }
    }
}

