/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.tasks;

import java.util.Optional;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.BusinessRuleTask;
import org.eclipse.bpmn2.ManualTask;
import org.eclipse.bpmn2.ReceiveTask;
import org.eclipse.bpmn2.SendTask;
import org.eclipse.bpmn2.ServiceTask;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.UserTask;
import org.eclipse.bpmn2.impl.TaskImpl;
import org.kie.workbench.common.stunner.bpmn.backend.converters.BPMNElementDecorators;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Match;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomAttribute;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.AbstractConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.NodeConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.BusinessRuleTaskPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.GenericServiceTaskPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.ScriptTaskPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.TaskPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.UserTaskPropertyReader;
import org.kie.workbench.common.stunner.bpmn.definition.BaseUserTask;
import org.kie.workbench.common.stunner.bpmn.definition.GenericServiceTask;
import org.kie.workbench.common.stunner.bpmn.definition.NoneTask;
import org.kie.workbench.common.stunner.bpmn.definition.ScriptTask;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Documentation;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Name;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.SLADueDate;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.TaskGeneralSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.service.GenericServiceTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.service.GenericServiceTaskInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.AdHocAutostart;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.BaseUserTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.BusinessRuleTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.DecisionName;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.DmnModelName;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.EmptyTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.IsAsync;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.IsMultipleInstance;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceCollectionInput;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceCollectionOutput;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceCompletionCondition;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceDataInput;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceDataOutput;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceExecutionMode;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.Namespace;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.OnEntryAction;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.OnExitAction;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.RuleFlowGroup;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.RuleLanguage;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.Script;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.TaskName;
import org.kie.workbench.common.stunner.bpmn.workitem.CustomTask;
import org.kie.workbench.common.stunner.bpmn.workitem.CustomTaskExecutionSet;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingRequest;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public abstract class BaseTaskConverter<U extends BaseUserTask<S>, S extends BaseUserTaskExecutionSet>
extends AbstractConverter
implements NodeConverter<Task> {
    protected final TypedFactoryManager factoryManager;
    private final PropertyReaderFactory propertyReaderFactory;

    public BaseTaskConverter(TypedFactoryManager factoryManager, PropertyReaderFactory propertyReaderFactory, MarshallingRequest.Mode mode) {
        super(mode);
        this.factoryManager = factoryManager;
        this.propertyReaderFactory = propertyReaderFactory;
    }

    @Override
    public Result<BpmnNode> convert(Task task) {
        return Match.of(Task.class, BpmnNode.class).when(BusinessRuleTask.class, this::businessRuleTask).when(org.eclipse.bpmn2.ScriptTask.class, this::scriptTask).when(UserTask.class, this::userTask).when(ServiceTask.class, this::serviceTaskResolver).whenExactly(TaskImpl.class, this::defaultTaskResolver).missing(ManualTask.class).missing(SendTask.class).missing(ReceiveTask.class).orElse(this::defaultTaskResolver).inputDecorator(BPMNElementDecorators.flowElementDecorator()).outputDecorator(BPMNElementDecorators.bpmnNodeDecorator()).mode(this.getMode()).apply(task);
    }

    private BpmnNode jbpmServiceTask(Task task) {
        return this.propertyReaderFactory.ofCustom(task).map(p -> {
            Node node = this.factoryManager.newNode(task.getId(), CustomTask.class);
            CustomTask definition = (CustomTask)((View)node.getContent()).getDefinition();
            definition.setName(p.getServiceTaskName());
            definition.getTaskType().setRawType(p.getServiceTaskName());
            definition.setDescription(p.getServiceTaskDescription());
            definition.setCategory(p.getServiceTaskCategory());
            definition.setDefaultHandler(p.getServiceTaskDefaultHandler());
            definition.setGeneral(new TaskGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
            definition.setDataIOSet(new DataIOSet(p.getAssignmentsInfo()));
            definition.setExecutionSet(new CustomTaskExecutionSet(new TaskName(p.getTaskName()), new IsAsync(Boolean.valueOf(p.isAsync())), new AdHocAutostart(Boolean.valueOf(p.isAdHocAutoStart())), new OnEntryAction(p.getOnEntryAction()), new OnExitAction(p.getOnExitAction()), new SLADueDate(p.getSlaDueDate())));
            definition.setSimulationSet(p.getSimulationSet());
            ((View)node.getContent()).setBounds(p.getBounds());
            definition.setDimensionsSet(p.getRectangleDimensionsSet());
            definition.setBackgroundSet(p.getBackgroundSet());
            definition.setFontSet(p.getFontSet());
            return BpmnNode.of(node, p);
        }).orElseGet(() -> this.noneTask(task));
    }

    BpmnNode bpmnServiceTask(ServiceTask task) {
        Node node = this.factoryManager.newNode(task.getId(), GenericServiceTask.class);
        GenericServiceTask definition = (GenericServiceTask)((View)node.getContent()).getDefinition();
        GenericServiceTaskPropertyReader p = this.propertyReaderFactory.of(task);
        if (p == null) {
            throw new NullPointerException(task.getClass().getCanonicalName());
        }
        definition.setGeneral(new TaskGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setExecutionSet(new GenericServiceTaskExecutionSet(new GenericServiceTaskInfo(p.getGenericServiceTask()), p.getAssignmentsInfo(), new AdHocAutostart(Boolean.valueOf(p.isAdHocAutostart())), new IsAsync(Boolean.valueOf(p.isAsync())), new IsMultipleInstance(Boolean.valueOf(p.isMultipleInstance())), new MultipleInstanceExecutionMode(p.isSequential()), new MultipleInstanceCollectionInput(p.getCollectionInput()), new MultipleInstanceDataInput(p.getDataInput()), new MultipleInstanceCollectionOutput(p.getCollectionOutput()), new MultipleInstanceDataOutput(p.getDataOutput()), new MultipleInstanceCompletionCondition(p.getCompletionCondition()), new OnEntryAction(p.getOnEntryAction()), new OnExitAction(p.getOnExitAction()), new SLADueDate(p.getSLADueDate())));
        ((View)node.getContent()).setBounds(p.getBounds());
        definition.setDimensionsSet(p.getRectangleDimensionsSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        definition.setFontSet(p.getFontSet());
        definition.setSimulationSet(p.getSimulationSet());
        definition.setDataIOSet(new DataIOSet(p.getAssignmentsInfo()));
        return BpmnNode.of(node, p);
    }

    private BpmnNode businessRuleTask(BusinessRuleTask task) {
        Node node = this.factoryManager.newNode(task.getId(), org.kie.workbench.common.stunner.bpmn.definition.BusinessRuleTask.class);
        org.kie.workbench.common.stunner.bpmn.definition.BusinessRuleTask definition = (org.kie.workbench.common.stunner.bpmn.definition.BusinessRuleTask)((View)node.getContent()).getDefinition();
        BusinessRuleTaskPropertyReader p = this.propertyReaderFactory.of(task);
        definition.setGeneral(new TaskGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setDataIOSet(new DataIOSet(p.getAssignmentsInfo()));
        RuleLanguage ruleLanguage = new RuleLanguage(p.getImplementation());
        RuleFlowGroup ruleFlowGroup = null;
        Namespace namespace = null;
        DecisionName decisionName = null;
        DmnModelName dmnModelName = null;
        if (ruleLanguage.getValue().equals("http://www.jboss.org/drools/rule")) {
            ruleFlowGroup = new RuleFlowGroup(p.getRuleFlowGroup());
            namespace = new Namespace();
            decisionName = new DecisionName();
            dmnModelName = new DmnModelName();
        } else if (ruleLanguage.getValue().equals("http://www.jboss.org/drools/dmn")) {
            ruleFlowGroup = new RuleFlowGroup();
            namespace = new Namespace(p.getNamespace());
            decisionName = new DecisionName(p.getDecisionName());
            dmnModelName = new DmnModelName(p.getDmnModelName());
        }
        definition.setExecutionSet(new BusinessRuleTaskExecutionSet(new RuleLanguage(p.getImplementation()), ruleFlowGroup, namespace, decisionName, dmnModelName, new OnEntryAction(p.getOnEntryAction()), new OnExitAction(p.getOnExitAction()), new IsAsync(Boolean.valueOf(p.isAsync())), new AdHocAutostart(Boolean.valueOf(p.isAdHocAutoStart())), new SLADueDate(p.getSlaDueDate())));
        definition.setSimulationSet(p.getSimulationSet());
        ((View)node.getContent()).setBounds(p.getBounds());
        definition.setDimensionsSet(p.getRectangleDimensionsSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        definition.setFontSet(p.getFontSet());
        return BpmnNode.of(node, p);
    }

    private BpmnNode scriptTask(org.eclipse.bpmn2.ScriptTask task) {
        Node node = this.factoryManager.newNode(task.getId(), ScriptTask.class);
        ScriptTask definition = (ScriptTask)((View)node.getContent()).getDefinition();
        ScriptTaskPropertyReader p = this.propertyReaderFactory.of(task);
        definition.setGeneral(new TaskGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setExecutionSet(new ScriptTaskExecutionSet(new Script(p.getScript()), new IsAsync(Boolean.valueOf(p.isAsync())), new AdHocAutostart(Boolean.valueOf(p.isAdHocAutoStart()))));
        ((View)node.getContent()).setBounds(p.getBounds());
        definition.setDimensionsSet(p.getRectangleDimensionsSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        definition.setFontSet(p.getFontSet());
        definition.setSimulationSet(p.getSimulationSet());
        return BpmnNode.of(node, p);
    }

    private BpmnNode userTask(UserTask task) {
        Node<View<U>, Edge> node = this.createNode(task.getId());
        BaseUserTask definition = (BaseUserTask)((View)node.getContent()).getDefinition();
        UserTaskPropertyReader p = this.propertyReaderFactory.of(task);
        definition.setGeneral(new TaskGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setSimulationSet(p.getSimulationSet());
        definition.setExecutionSet(this.createUserTaskExecutionSet(p));
        ((View)node.getContent()).setBounds(p.getBounds());
        definition.setDimensionsSet(p.getRectangleDimensionsSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        definition.setFontSet(p.getFontSet());
        return BpmnNode.of(node, p);
    }

    private BpmnNode defaultTaskResolver(Task task) {
        return Optional.ofNullable(CustomAttribute.serviceTaskName.of((BaseElement)task).get()).filter(StringUtils::nonEmpty).filter(name -> this.propertyReaderFactory.ofCustom(task).isPresent()).map(name -> this.jbpmServiceTask(task)).orElseGet(() -> this.noneTask(task));
    }

    private BpmnNode serviceTaskResolver(Task task) {
        ServiceTask serviceTask = (ServiceTask)task;
        if (StringUtils.nonEmpty((String)CustomAttribute.serviceImplementation.of((BaseElement)task).get()) || StringUtils.nonEmpty((String)serviceTask.getImplementation())) {
            return this.bpmnServiceTask(serviceTask);
        }
        return this.jbpmServiceTask(task);
    }

    private BpmnNode noneTask(Task task) {
        Node node = this.factoryManager.newNode(task.getId(), NoneTask.class);
        TaskPropertyReader p = this.propertyReaderFactory.of(task);
        NoneTask definition = (NoneTask)((View)node.getContent()).getDefinition();
        definition.setGeneral(new TaskGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setExecutionSet(new EmptyTaskExecutionSet());
        definition.setSimulationSet(p.getSimulationSet());
        ((View)node.getContent()).setBounds(p.getBounds());
        definition.setDimensionsSet(p.getRectangleDimensionsSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        definition.setFontSet(p.getFontSet());
        return BpmnNode.of(node, p);
    }

    protected abstract Node<View<U>, Edge> createNode(String var1);

    protected abstract S createUserTaskExecutionSet(UserTaskPropertyReader var1);
}

