/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner;

import org.assertj.core.api.Assertions;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Import;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.ConverterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.DefinitionsBuildingContext;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.DefinitionsConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDiagramImpl;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.AdHoc;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.DiagramSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.Executable;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.Id;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.Package;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.ProcessInstanceDescription;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.ProcessType;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.Version;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.imports.Imports;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.imports.ImportsValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.imports.WSDLImport;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Documentation;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Name;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.SLADueDate;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.core.graph.impl.GraphImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.kie.workbench.common.stunner.core.graph.store.GraphNodeStore;
import org.kie.workbench.common.stunner.core.graph.store.GraphNodeStoreImpl;

public class DefinitionsConverterTest {
    @Test
    public void JBPM_7526_shouldSetExporter() {
        GraphNodeStoreImpl nodeStore = new GraphNodeStoreImpl();
        NodeImpl x = new NodeImpl("x");
        BPMNDiagramImpl diag = new BPMNDiagramImpl();
        diag.setDiagramSet(new DiagramSet(new Name("x"), new Documentation("doc"), new Id("x"), new Package("org.jbpm"), new ProcessType(), new Version("1.0"), new AdHoc(Boolean.valueOf(false)), new ProcessInstanceDescription("descr"), new Imports(), new Executable(Boolean.valueOf(true)), new SLADueDate("")));
        x.setContent((Object)new ViewImpl((Object)diag, Bounds.create()));
        nodeStore.add((Node)x);
        ConverterFactory f = new ConverterFactory(new DefinitionsBuildingContext((Graph)new GraphImpl("x", (GraphNodeStore)nodeStore)), new PropertyWriterFactory());
        DefinitionsConverter definitionsConverter = new DefinitionsConverter(f, new PropertyWriterFactory());
        Definitions definitions = definitionsConverter.toDefinitions();
        Assertions.assertThat((String)definitions.getExporter()).isNotBlank();
        Assertions.assertThat((String)definitions.getExporterVersion()).isNotBlank();
    }

    @Test
    public void toDefinitions() {
        String LOCATION = "Location";
        String NAMESPACE = "Namespace";
        ImportsValue importsValue = new ImportsValue();
        importsValue.addImport(new WSDLImport("Location", "Namespace"));
        BPMNDiagramImpl diag = new BPMNDiagramImpl();
        diag.setDiagramSet(new DiagramSet(new Name(), new Documentation(), new Id(), new Package(), new ProcessType(), new Version(), new AdHoc(Boolean.valueOf(false)), new ProcessInstanceDescription(), new Imports(importsValue), new Executable(Boolean.valueOf(true)), new SLADueDate()));
        GraphNodeStoreImpl nodeStore = new GraphNodeStoreImpl();
        NodeImpl x = new NodeImpl("x");
        x.setContent((Object)new ViewImpl((Object)diag, Bounds.create()));
        nodeStore.add((Node)x);
        ConverterFactory f = new ConverterFactory(new DefinitionsBuildingContext((Graph)new GraphImpl("x", (GraphNodeStore)nodeStore)), new PropertyWriterFactory());
        DefinitionsConverter definitionsConverter = new DefinitionsConverter(f, new PropertyWriterFactory());
        Definitions definitions = definitionsConverter.toDefinitions();
        this.assertImportsValue("Location", "Namespace", definitions);
    }

    private void assertImportsValue(String LOCATION, String NAMESPACE, Definitions definitions) {
        Import imp = (Import)definitions.getImports().get(0);
        Assert.assertNotNull((Object)imp);
        Assert.assertEquals((Object)LOCATION, (Object)imp.getLocation());
        Assert.assertEquals((Object)NAMESPACE, (Object)imp.getNamespace());
    }
}

