/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.Arrays;
import java.util.Collections;
import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.DataObjectReference;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jboss.drools.DroolsPackage;
import org.jboss.drools.MetaDataType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.DataObjectPropertyReader;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DataObjectPropertyReaderTest {
    private DataObjectPropertyReader tested;
    @Mock
    private DataObjectReference ref;
    @Mock
    private DataObject dataObject;
    @Mock
    private BPMNDiagram diagram;
    @Mock
    private BPMNShape shape;
    private static final double RESOLUTION_FACTOR = 1.0;
    @Mock
    private ExtensionAttributeValue extensionAttributeValue;
    @Mock
    private FeatureMap valueMap;
    @Mock
    private MetaDataType metaDataType;

    @Before
    public void setUp() {
        this.dataObject = (DataObject)Mockito.spy((Object)Factories.bpmn2.createDataObject());
        Mockito.when((Object)this.ref.getDataObjectRef()).thenReturn((Object)this.dataObject);
        Mockito.when((Object)this.dataObject.getName()).thenReturn((Object)"name");
        Mockito.when((Object)this.dataObject.getExtensionValues()).thenReturn(Arrays.asList(this.extensionAttributeValue));
        Mockito.when((Object)this.extensionAttributeValue.getValue()).thenReturn((Object)this.valueMap);
        Mockito.when((Object)this.valueMap.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, true)).thenReturn(Arrays.asList(this.metaDataType));
        Mockito.when((Object)this.metaDataType.getName()).thenReturn((Object)CustomElement.name.name());
        Mockito.when((Object)this.metaDataType.getMetaValue()).thenReturn((Object)"custom");
        this.tested = new DataObjectPropertyReader(this.ref, this.diagram, this.shape, 1.0);
    }

    @Test
    public void getExtendedName() {
        String name = this.tested.getName();
        Assert.assertEquals((Object)"custom", (Object)name);
    }

    @Test
    public void getName() {
        Mockito.when((Object)this.dataObject.getExtensionValues()).thenReturn(Collections.emptyList());
        String name = this.tested.getName();
        Assert.assertEquals((Object)"name", (Object)name);
    }
}

