/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml.elements;

import java.util.ArrayList;
import java.util.Map;
import org.jbpm.workflow.core.node.Assignment;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DataAssociationFactory {
    private static final Logger logger = LoggerFactory.getLogger(DataAssociationFactory.class);

    private DataAssociationFactory() {
    }

    public static DataAssociation readDataOutputAssociation(Node xmlNode, Map<String, String> dataOutputs) {
        NodeList nodeList = xmlNode.getChildNodes();
        String source = null;
        String target = null;
        Transformation transformation = null;
        ArrayList<Assignment> assignment = new ArrayList<Assignment>();
        block12: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            switch (subNode.getNodeName()) {
                case "sourceRef": {
                    source = subNode.getTextContent();
                    if (!dataOutputs.containsKey(source)) {
                        logger.warn("Data outputs in this node {} does not contain source {}", (Object)xmlNode.getAttributes().getNamedItem("id"), (Object)source);
                    }
                    source = dataOutputs.get(source);
                    continue block12;
                }
                case "targetRef": {
                    target = subNode.getTextContent();
                    continue block12;
                }
                case "transformation": {
                    String lang = subNode.getAttributes().getNamedItem("language").getNodeValue();
                    String expression = subNode.getTextContent();
                    transformation = new Transformation(lang, expression, source);
                    continue block12;
                }
                case "assignment": {
                    assignment.add(DataAssociationFactory.readAssignment(subNode));
                }
            }
        }
        return new DataAssociation(source, target, assignment, transformation);
    }

    private static Assignment readAssignment(Node xmlNode) {
        NodeList nodeList = xmlNode.getChildNodes();
        String from = null;
        String to = null;
        block8: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            switch (subNode.getNodeName()) {
                case "from": {
                    from = subNode.getTextContent();
                    continue block8;
                }
                case "to": {
                    to = subNode.getTextContent();
                }
            }
        }
        return new Assignment("XPath", from, to);
    }
}

