/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util.scheduler;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.mariadb.jdbc.internal.util.scheduler.DynamicSizedSchedulerImpl;
import org.mariadb.jdbc.internal.util.scheduler.DynamicSizedSchedulerInterface;
import org.mariadb.jdbc.internal.util.scheduler.FixedSizedSchedulerImpl;

public class SchedulerServiceProviderHolder {
    public static SchedulerProvider DEFAULT_PROVIDER = new SchedulerProvider(){

        @Override
        public DynamicSizedSchedulerInterface getScheduler(int minimumThreads) {
            return new DynamicSizedSchedulerImpl(minimumThreads);
        }

        @Override
        public ScheduledThreadPoolExecutor getFixedSizeScheduler(int minimumThreads) {
            return new FixedSizedSchedulerImpl(minimumThreads);
        }
    };
    private static volatile SchedulerProvider currentProvider = null;

    public static void setSchedulerProvider(SchedulerProvider newProvider) {
        currentProvider = newProvider;
    }

    public static SchedulerProvider getSchedulerProvider() {
        SchedulerProvider result = currentProvider;
        if (result == null) {
            return DEFAULT_PROVIDER;
        }
        return result;
    }

    public static DynamicSizedSchedulerInterface getScheduler(int initialThreadCount) {
        return SchedulerServiceProviderHolder.getSchedulerProvider().getScheduler(initialThreadCount);
    }

    public static ScheduledExecutorService getFixedSizeScheduler(int initialThreadCount) {
        return SchedulerServiceProviderHolder.getSchedulerProvider().getFixedSizeScheduler(initialThreadCount);
    }

    public static interface SchedulerProvider {
        public DynamicSizedSchedulerInterface getScheduler(int var1);

        public ScheduledExecutorService getFixedSizeScheduler(int var1);
    }
}

