/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.infinispan.protostream.annotations.ProtoEnum;
import org.infinispan.protostream.annotations.ProtoEnumValue;
import org.infinispan.protostream.annotations.ProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoSchemaBuilderException;
import org.infinispan.protostream.annotations.impl.DocumentationExtractor;
import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.ProtoEnumValueMetadata;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;
import org.infinispan.protostream.impl.Log;

final class ProtoEnumTypeMetadata
extends ProtoTypeMetadata {
    private static final Log log = Log.LogFactory.getLog(ProtoEnumTypeMetadata.class);
    private Map<Integer, ProtoEnumValueMetadata> membersByNumber;
    private Map<String, ProtoEnumValueMetadata> membersByName;

    ProtoEnumTypeMetadata(Class<? extends Enum> enumClass) {
        super(ProtoEnumTypeMetadata.getProtoName(enumClass), enumClass, DocumentationExtractor.getDocumentation(enumClass));
    }

    private static String getProtoName(Class<? extends Enum> enumClass) {
        ProtoEnum annotation = enumClass.getAnnotation(ProtoEnum.class);
        return annotation == null || annotation.name().isEmpty() ? enumClass.getSimpleName() : annotation.name();
    }

    @Override
    public void scanMemberAnnotations() {
        if (this.membersByNumber == null) {
            this.membersByNumber = new TreeMap<Integer, ProtoEnumValueMetadata>();
            this.membersByName = new HashMap<String, ProtoEnumValueMetadata>();
            for (Field f : this.javaClass.getDeclaredFields()) {
                if (!f.isEnumConstant()) continue;
                ProtoEnumValue annotation = f.getAnnotation(ProtoEnumValue.class);
                if (annotation == null) {
                    throw new ProtoSchemaBuilderException("Enum members must have the @ProtoEnumValue annotation: " + this.getJavaClassName() + '.' + f.getName());
                }
                if (this.membersByNumber.containsKey(annotation.number())) {
                    throw new ProtoSchemaBuilderException("Found duplicate definition of Protobuf enum tag " + annotation.number() + " on enum member: " + this.getJavaClassName() + '.' + f.getName());
                }
                String name = annotation.name();
                if (name.isEmpty()) {
                    name = f.getName();
                }
                Enum e = null;
                try {
                    e = (Enum)f.get(this.javaClass);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                if (this.membersByName.containsKey(name)) {
                    throw new ProtoSchemaBuilderException("Found duplicate definition of Protobuf enum constant " + name + " on enum member: " + this.getJavaClassName() + '.' + f.getName());
                }
                ProtoEnumValueMetadata pevm = new ProtoEnumValueMetadata(annotation.number(), name, e, DocumentationExtractor.getDocumentation(f));
                this.membersByNumber.put(annotation.number(), pevm);
                this.membersByName.put(pevm.getProtoName(), pevm);
            }
            if (this.membersByNumber.isEmpty()) {
                throw new ProtoSchemaBuilderException("Enums without members are not allowed: " + this.getJavaClassName());
            }
        }
    }

    public Map<Integer, ProtoEnumValueMetadata> getMembers() {
        this.scanMemberAnnotations();
        return this.membersByNumber;
    }

    @Override
    public boolean isEnum() {
        return true;
    }

    @Override
    public ProtoEnumValueMetadata getEnumMemberByName(String name) {
        this.scanMemberAnnotations();
        return this.membersByName.get(name);
    }

    @Override
    public void generateProto(IndentWriter iw) {
        this.scanMemberAnnotations();
        iw.append("\n\n");
        ProtoEnumTypeMetadata.appendDocumentation(iw, this.documentation);
        iw.append("enum ").append(this.name);
        if (ProtoSchemaBuilder.generateSchemaDebugComments) {
            iw.append(" /* ").append(this.getJavaClassName()).append(" */");
        }
        iw.append(" {\n");
        iw.inc();
        for (ProtoEnumValueMetadata m : this.membersByNumber.values()) {
            m.generateProto(iw);
        }
        iw.dec();
        iw.append("}\n");
    }
}

