/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import bpsim.ElementParameters;
import java.util.List;
import java.util.Set;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.OutputSet;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.InitializedVariable;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.ParsedAssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.EventPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.SimulationAttributeSets;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.SimulationAttributeSet;

public class CatchEventPropertyWriter
extends EventPropertyWriter {
    private final CatchEvent event;
    private ElementParameters simulationParameters;
    private final Set<DataObject> dataObjects;

    public CatchEventPropertyWriter(CatchEvent event, VariableScope variableScope, Set<DataObject> dataObjects) {
        super((Event)event, variableScope);
        this.event = event;
        this.dataObjects = dataObjects;
    }

    @Override
    public void setAssignmentsInfo(AssignmentsInfo info) {
        ParsedAssignmentsInfo assignmentsInfo = ParsedAssignmentsInfo.of(info);
        List<InitializedVariable.InitializedOutputVariable> outputs = assignmentsInfo.createInitializedOutputVariables(this.getId(), this.variableScope, this.dataObjects);
        if (outputs.isEmpty()) {
            return;
        }
        if (outputs.size() > 1) {
            throw new IllegalArgumentException("Output Associations should be at most 1 in Catch Events");
        }
        InitializedVariable.InitializedOutputVariable output = outputs.get(0);
        DataOutput dataOutput = output.getDataOutput();
        this.event.getDataOutputs().add(dataOutput);
        this.getOutputSet().getDataOutputRefs().add(dataOutput);
        this.addItemDefinition(dataOutput.getItemSubjectRef());
        DataOutputAssociation dataOutputAssociation = output.getDataOutputAssociation();
        if (dataOutputAssociation != null) {
            this.event.getDataOutputAssociation().add(dataOutputAssociation);
        }
    }

    private OutputSet getOutputSet() {
        OutputSet outputSet = this.event.getOutputSet();
        if (outputSet == null) {
            outputSet = Factories.bpmn2.createOutputSet();
            this.event.setOutputSet(outputSet);
        }
        return outputSet;
    }

    public void setSimulationSet(SimulationAttributeSet simulationSet) {
        this.simulationParameters = SimulationAttributeSets.toElementParameters(simulationSet);
        this.simulationParameters.setElementRef(this.getId());
    }

    @Override
    public ElementParameters getSimulationParameters() {
        return this.simulationParameters;
    }

    @Override
    public void addEventDefinition(EventDefinition eventDefinition) {
        this.event.getEventDefinitions().add(eventDefinition);
    }

    public void setCancelActivity(Boolean value) {
    }
}

