/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.backend.service;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.QueryServicesClient;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.service.SpecManagementService;
import org.kie.server.controller.impl.KieServerInstanceManager;
import org.kie.workbench.common.screens.server.management.service.ContainerService;

@Service
@ApplicationScoped
public class ContainerServiceImpl
implements ContainerService {
    private KieServerInstanceManager kieServerInstanceManager = KieServerInstanceManager.getInstance();
    @Inject
    @Any
    private SpecManagementService specManagementService;

    public boolean isRunningContainer(ContainerSpec containerSpec) {
        ServerTemplate serverTemplate = this.specManagementService.getServerTemplate(containerSpec.getServerTemplateKey().getId());
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        for (ServerInstanceKey serverInstanceKey : serverTemplate.getServerInstanceKeys()) {
            KieServicesClient client = this.kieServerInstanceManager.getClient(serverInstanceKey.getUrl());
            QueryServicesClient queryServicesClient = (QueryServicesClient)client.getServicesClient(QueryServicesClient.class);
            List processInstances = queryServicesClient.findProcessInstancesByContainerId(containerSpec.getId(), Arrays.asList(0, 1, 4), Integer.valueOf(0), Integer.valueOf(100));
            if (processInstances.isEmpty()) continue;
            atomicBoolean.set(true);
            break;
        }
        return atomicBoolean.get();
    }

    protected void setKieServerInstanceManager(KieServerInstanceManager kieServerInstanceManager) {
        this.kieServerInstanceManager = kieServerInstanceManager;
    }

    protected void setSpecManagementService(SpecManagementService specManagementService) {
        this.specManagementService = specManagementService;
    }
}

