/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.ConcurrentMapLong;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.query.InnerHitContextBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.DefaultSearchContext;
import org.elasticsearch.search.SearchContextException;
import org.elasticsearch.search.SearchContextMissingException;
import org.elasticsearch.search.SearchExtBuilder;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.AggregationInitializationException;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.SearchContextAggregations;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.collapse.CollapseContext;
import org.elasticsearch.search.dfs.DfsPhase;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.fetch.ScrollQueryFetchSearchResult;
import org.elasticsearch.search.fetch.ShardFetchRequest;
import org.elasticsearch.search.fetch.subphase.DocValueFieldsContext;
import org.elasticsearch.search.fetch.subphase.ScriptFieldsContext;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.elasticsearch.search.internal.ScrollContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.profile.Profilers;
import org.elasticsearch.search.query.QueryPhase;
import org.elasticsearch.search.query.QuerySearchRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.ScrollQuerySearchResult;
import org.elasticsearch.search.rescore.RescoreBuilder;
import org.elasticsearch.search.searchafter.SearchAfterBuilder;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.completion.CompletionSuggestion;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;

public class SearchService
extends AbstractLifecycleComponent
implements IndexEventListener {
    public static final Setting<TimeValue> DEFAULT_KEEPALIVE_SETTING = Setting.positiveTimeSetting("search.default_keep_alive", TimeValue.timeValueMinutes(5L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> KEEPALIVE_INTERVAL_SETTING = Setting.positiveTimeSetting("search.keep_alive_interval", TimeValue.timeValueMinutes(1L), Setting.Property.NodeScope);
    public static final Setting<Boolean> LOW_LEVEL_CANCELLATION_SETTING = Setting.boolSetting("search.low_level_cancellation", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final TimeValue NO_TIMEOUT = TimeValue.timeValueMillis(-1L);
    public static final Setting<TimeValue> DEFAULT_SEARCH_TIMEOUT_SETTING = Setting.timeSetting("search.default_search_timeout", NO_TIMEOUT, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final ScriptService scriptService;
    private final BigArrays bigArrays;
    private final DfsPhase dfsPhase = new DfsPhase();
    private final QueryPhase queryPhase;
    private final FetchPhase fetchPhase;
    private final long defaultKeepAlive;
    private volatile TimeValue defaultSearchTimeout;
    private volatile boolean lowLevelCancellation;
    private final ThreadPool.Cancellable keepAliveReaper;
    private final AtomicLong idGenerator = new AtomicLong();
    private final ConcurrentMapLong<SearchContext> activeContexts = ConcurrentCollections.newConcurrentMapLongWithAggressiveConcurrency();

    public SearchService(ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ScriptService scriptService, BigArrays bigArrays, FetchPhase fetchPhase) {
        super(clusterService.getSettings());
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.scriptService = scriptService;
        this.bigArrays = bigArrays;
        this.queryPhase = new QueryPhase(this.settings);
        this.fetchPhase = fetchPhase;
        TimeValue keepAliveInterval = KEEPALIVE_INTERVAL_SETTING.get(this.settings);
        this.defaultKeepAlive = DEFAULT_KEEPALIVE_SETTING.get(this.settings).millis();
        this.keepAliveReaper = threadPool.scheduleWithFixedDelay(new Reaper(), keepAliveInterval, "same");
        this.defaultSearchTimeout = DEFAULT_SEARCH_TIMEOUT_SETTING.get(this.settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(DEFAULT_SEARCH_TIMEOUT_SETTING, this::setDefaultSearchTimeout);
        this.lowLevelCancellation = LOW_LEVEL_CANCELLATION_SETTING.get(this.settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(LOW_LEVEL_CANCELLATION_SETTING, this::setLowLevelCancellation);
    }

    private void setDefaultSearchTimeout(TimeValue defaultSearchTimeout) {
        this.defaultSearchTimeout = defaultSearchTimeout;
    }

    private void setLowLevelCancellation(Boolean lowLevelCancellation) {
        this.lowLevelCancellation = lowLevelCancellation;
    }

    @Override
    public void afterIndexRemoved(Index index, IndexSettings indexSettings, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
        if (reason == IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.DELETED || reason == IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.CLOSED) {
            this.freeAllContextForIndex(index);
        }
    }

    protected void putContext(SearchContext context) {
        SearchContext previous = this.activeContexts.put(context.id(), context);
        assert (previous == null);
    }

    protected SearchContext removeContext(long id) {
        return this.activeContexts.remove(id);
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
        for (SearchContext context : this.activeContexts.values()) {
            this.freeContext(context.id());
        }
    }

    @Override
    protected void doClose() {
        this.doStop();
        this.keepAliveReaper.cancel();
    }

    public DfsSearchResult executeDfsPhase(ShardSearchRequest request, SearchTask task) throws IOException {
        SearchContext context = this.createAndPutContext(request);
        context.incRef();
        try {
            context.setTask(task);
            this.contextProcessing(context);
            this.dfsPhase.execute(context);
            this.contextProcessedSuccessfully(context);
            DfsSearchResult dfsSearchResult = context.dfsResult();
            return dfsSearchResult;
        }
        catch (Exception e) {
            this.logger.trace("Dfs phase failed", (Throwable)e);
            this.processFailure(context, e);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            this.cleanContext(context);
        }
    }

    private void loadOrExecuteQueryPhase(ShardSearchRequest request, SearchContext context) throws Exception {
        boolean canCache = this.indicesService.canCache(request, context);
        context.getQueryShardContext().freezeContext();
        if (canCache) {
            this.indicesService.loadIntoContext(request, context, this.queryPhase);
        } else {
            this.queryPhase.execute(context);
        }
    }

    public SearchPhaseResult executeQueryPhase(ShardSearchRequest request, SearchTask task) throws IOException {
        SearchContext context = this.createAndPutContext(request);
        SearchOperationListener operationListener = context.indexShard().getSearchOperationListener();
        context.incRef();
        boolean queryPhaseSuccess = false;
        try {
            context.setTask(task);
            operationListener.onPreQueryPhase(context);
            long time = System.nanoTime();
            this.contextProcessing(context);
            this.loadOrExecuteQueryPhase(request, context);
            if (!context.queryResult().hasSearchContext() && context.scrollContext() == null) {
                this.freeContext(context.id());
            } else {
                this.contextProcessedSuccessfully(context);
            }
            long afterQueryTime = System.nanoTime();
            queryPhaseSuccess = true;
            operationListener.onQueryPhase(context, afterQueryTime - time);
            if (request.numberOfShards() == 1) {
                QueryFetchSearchResult queryFetchSearchResult = this.executeFetchPhase(context, operationListener, afterQueryTime);
                return queryFetchSearchResult;
            }
            QuerySearchResult querySearchResult = context.queryResult();
            return querySearchResult;
        }
        catch (Exception e) {
            if (e instanceof ExecutionException) {
                Exception exception = e = e.getCause() == null || e.getCause() instanceof Exception ? (Exception)e.getCause() : new ElasticsearchException(e.getCause());
            }
            if (!queryPhaseSuccess) {
                operationListener.onFailedQueryPhase(context);
            }
            this.logger.trace("Query phase failed", (Throwable)e);
            this.processFailure(context, e);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            this.cleanContext(context);
        }
    }

    private QueryFetchSearchResult executeFetchPhase(SearchContext context, SearchOperationListener operationListener, long afterQueryTime) {
        operationListener.onPreFetchPhase(context);
        try {
            this.shortcutDocIdsToLoad(context);
            this.fetchPhase.execute(context);
            if (this.fetchPhaseShouldFreeContext(context)) {
                this.freeContext(context.id());
            } else {
                this.contextProcessedSuccessfully(context);
            }
        }
        catch (Exception e) {
            operationListener.onFailedFetchPhase(context);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        operationListener.onFetchPhase(context, System.nanoTime() - afterQueryTime);
        return new QueryFetchSearchResult(context.queryResult(), context.fetchResult());
    }

    public ScrollQuerySearchResult executeQueryPhase(InternalScrollSearchRequest request, SearchTask task) {
        SearchContext context = this.findContext(request.id(), request);
        SearchOperationListener operationListener = context.indexShard().getSearchOperationListener();
        context.incRef();
        try {
            context.setTask(task);
            operationListener.onPreQueryPhase(context);
            long time = System.nanoTime();
            this.contextProcessing(context);
            this.processScroll(request, context);
            this.queryPhase.execute(context);
            this.contextProcessedSuccessfully(context);
            operationListener.onQueryPhase(context, System.nanoTime() - time);
            ScrollQuerySearchResult scrollQuerySearchResult = new ScrollQuerySearchResult(context.queryResult(), context.shardTarget());
            return scrollQuerySearchResult;
        }
        catch (Exception e) {
            operationListener.onFailedQueryPhase(context);
            this.logger.trace("Query phase failed", (Throwable)e);
            this.processFailure(context, e);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            this.cleanContext(context);
        }
    }

    public QuerySearchResult executeQueryPhase(QuerySearchRequest request, SearchTask task) {
        SearchContext context = this.findContext(request.id(), request);
        context.setTask(task);
        IndexShard indexShard = context.indexShard();
        SearchOperationListener operationListener = indexShard.getSearchOperationListener();
        context.incRef();
        try {
            this.contextProcessing(context);
            context.searcher().setAggregatedDfs(request.dfs());
            operationListener.onPreQueryPhase(context);
            long time = System.nanoTime();
            this.queryPhase.execute(context);
            if (!context.queryResult().hasSearchContext() && context.scrollContext() == null) {
                this.freeContext(context.id());
            } else {
                this.contextProcessedSuccessfully(context);
            }
            operationListener.onQueryPhase(context, System.nanoTime() - time);
            QuerySearchResult querySearchResult = context.queryResult();
            return querySearchResult;
        }
        catch (Exception e) {
            operationListener.onFailedQueryPhase(context);
            this.logger.trace("Query phase failed", (Throwable)e);
            this.processFailure(context, e);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            this.cleanContext(context);
        }
    }

    private boolean fetchPhaseShouldFreeContext(SearchContext context) {
        if (context.scrollContext() == null) {
            return true;
        }
        return context.scrollContext().scroll == null;
    }

    public ScrollQueryFetchSearchResult executeFetchPhase(InternalScrollSearchRequest request, SearchTask task) {
        SearchContext context = this.findContext(request.id(), request);
        context.incRef();
        try {
            context.setTask(task);
            this.contextProcessing(context);
            SearchOperationListener operationListener = context.indexShard().getSearchOperationListener();
            this.processScroll(request, context);
            operationListener.onPreQueryPhase(context);
            long time = System.nanoTime();
            try {
                this.queryPhase.execute(context);
            }
            catch (Exception e) {
                operationListener.onFailedQueryPhase(context);
                throw ExceptionsHelper.convertToRuntime(e);
            }
            long afterQueryTime = System.nanoTime();
            operationListener.onQueryPhase(context, afterQueryTime - time);
            QueryFetchSearchResult fetchSearchResult = this.executeFetchPhase(context, operationListener, afterQueryTime);
            ScrollQueryFetchSearchResult scrollQueryFetchSearchResult = new ScrollQueryFetchSearchResult(fetchSearchResult, context.shardTarget());
            return scrollQueryFetchSearchResult;
        }
        catch (Exception e) {
            this.logger.trace("Fetch phase failed", (Throwable)e);
            this.processFailure(context, e);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            this.cleanContext(context);
        }
    }

    public FetchSearchResult executeFetchPhase(ShardFetchRequest request, SearchTask task) {
        SearchContext context = this.findContext(request.id(), request);
        SearchOperationListener operationListener = context.indexShard().getSearchOperationListener();
        context.incRef();
        try {
            context.setTask(task);
            this.contextProcessing(context);
            if (request.lastEmittedDoc() != null) {
                context.scrollContext().lastEmittedDoc = request.lastEmittedDoc();
            }
            context.docIdsToLoad(request.docIds(), 0, request.docIdsSize());
            operationListener.onPreFetchPhase(context);
            long time = System.nanoTime();
            this.fetchPhase.execute(context);
            if (this.fetchPhaseShouldFreeContext(context)) {
                this.freeContext(request.id());
            } else {
                this.contextProcessedSuccessfully(context);
            }
            operationListener.onFetchPhase(context, System.nanoTime() - time);
            FetchSearchResult fetchSearchResult = context.fetchResult();
            return fetchSearchResult;
        }
        catch (Exception e) {
            operationListener.onFailedFetchPhase(context);
            this.logger.trace("Fetch phase failed", (Throwable)e);
            this.processFailure(context, e);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            this.cleanContext(context);
        }
    }

    private SearchContext findContext(long id, TransportRequest request) throws SearchContextMissingException {
        SearchContext context = this.activeContexts.get(id);
        if (context == null) {
            throw new SearchContextMissingException(id);
        }
        SearchOperationListener operationListener = context.indexShard().getSearchOperationListener();
        try {
            operationListener.validateSearchContext(context, request);
            return context;
        }
        catch (Exception e) {
            this.processFailure(context, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final SearchContext createAndPutContext(ShardSearchRequest request) throws IOException {
        SearchContext context = this.createContext(request, null);
        boolean success = false;
        try {
            this.putContext(context);
            if (request.scroll() != null) {
                context.indexShard().getSearchOperationListener().onNewScrollContext(context);
            }
            context.indexShard().getSearchOperationListener().onNewContext(context);
            success = true;
            SearchContext searchContext = context;
            return searchContext;
        }
        finally {
            if (!success) {
                this.freeContext(context.id());
            }
        }
    }

    final SearchContext createContext(ShardSearchRequest request, @Nullable Engine.Searcher searcher) throws IOException {
        DefaultSearchContext context = this.createSearchContext(request, this.defaultSearchTimeout, searcher);
        try {
            if (request.scroll() != null) {
                context.scrollContext(new ScrollContext());
                context.scrollContext().scroll = request.scroll();
            }
            this.parseSource(context, request.source());
            if (context.from() == -1) {
                context.from(0);
            }
            if (context.size() == -1) {
                context.size(10);
            }
            this.dfsPhase.preProcess(context);
            this.queryPhase.preProcess(context);
            this.fetchPhase.preProcess(context);
            long keepAlive = this.defaultKeepAlive;
            if (request.scroll() != null && request.scroll().keepAlive() != null) {
                keepAlive = request.scroll().keepAlive().millis();
            }
            context.keepAlive(keepAlive);
            context.lowLevelCancellation(this.lowLevelCancellation);
        }
        catch (Exception e) {
            context.close();
            throw ExceptionsHelper.convertToRuntime(e);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DefaultSearchContext createSearchContext(ShardSearchRequest request, TimeValue timeout, @Nullable Engine.Searcher searcher) throws IOException {
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexShard indexShard = indexService.getShard(request.shardId().getId());
        SearchShardTarget shardTarget = new SearchShardTarget(this.clusterService.localNode().getId(), indexShard.shardId(), request.getClusterAlias(), OriginalIndices.NONE);
        Engine.Searcher engineSearcher = searcher == null ? indexShard.acquireSearcher("search") : searcher;
        DefaultSearchContext searchContext = new DefaultSearchContext(this.idGenerator.incrementAndGet(), request, shardTarget, engineSearcher, indexService, indexShard, this.bigArrays, this.threadPool.estimatedTimeInMillisCounter(), timeout, this.fetchPhase);
        boolean success = false;
        try {
            request.rewrite(new QueryShardContext(searchContext.getQueryShardContext()));
            assert (searchContext.getQueryShardContext().isCachable());
            success = true;
            if (success) return searchContext;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{searchContext});
            throw throwable;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{searchContext});
        return searchContext;
    }

    private void freeAllContextForIndex(Index index) {
        assert (index != null);
        for (SearchContext ctx : this.activeContexts.values()) {
            if (!index.equals(ctx.indexShard().shardId().getIndex())) continue;
            this.freeContext(ctx.id());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean freeContext(long id) {
        SearchContext context = this.removeContext(id);
        if (context != null) {
            assert (context.refCount() > 0) : " refCount must be > 0: " + context.refCount();
            try {
                context.indexShard().getSearchOperationListener().onFreeContext(context);
                if (context.scrollContext() != null) {
                    context.indexShard().getSearchOperationListener().onFreeScrollContext(context);
                }
            }
            finally {
                context.close();
            }
            return true;
        }
        return false;
    }

    public void freeAllScrollContexts() {
        for (SearchContext searchContext : this.activeContexts.values()) {
            if (searchContext.scrollContext() == null) continue;
            this.freeContext(searchContext.id());
        }
    }

    private void contextProcessing(SearchContext context) {
        context.accessed(-1L);
    }

    private void contextProcessedSuccessfully(SearchContext context) {
        context.accessed(this.threadPool.relativeTimeInMillis());
    }

    private void cleanContext(SearchContext context) {
        try {
            context.clearReleasables(SearchContext.Lifetime.PHASE);
            context.setTask(null);
        }
        finally {
            context.decRef();
        }
    }

    private void processFailure(SearchContext context, Exception e) {
        this.freeContext(context.id());
        try {
            if (Lucene.isCorruptionException(e)) {
                context.indexShard().failShard("search execution corruption failure", e);
            }
        }
        catch (Exception inner) {
            inner.addSuppressed(e);
            this.logger.warn("failed to process shard failure to (potentially) send back shard failure on corruption", (Throwable)inner);
        }
    }

    private void parseSource(DefaultSearchContext context, SearchSourceBuilder source) throws SearchContextException {
        if (source == null) {
            return;
        }
        QueryShardContext queryShardContext = context.getQueryShardContext();
        context.from(source.from());
        context.size(source.size());
        HashMap<String, InnerHitContextBuilder> innerHitBuilders = new HashMap<String, InnerHitContextBuilder>();
        if (source.query() != null) {
            InnerHitContextBuilder.extractInnerHits(source.query(), innerHitBuilders);
            context.parsedQuery(queryShardContext.toQuery(source.query()));
        }
        if (source.postFilter() != null) {
            InnerHitContextBuilder.extractInnerHits(source.postFilter(), innerHitBuilders);
            context.parsedPostFilter(queryShardContext.toQuery(source.postFilter()));
        }
        if (innerHitBuilders.size() > 0) {
            for (Map.Entry entry : innerHitBuilders.entrySet()) {
                try {
                    ((InnerHitContextBuilder)entry.getValue()).build(context, context.innerHits());
                }
                catch (IOException e) {
                    throw new SearchContextException(context, "failed to build inner_hits", (Throwable)e);
                }
            }
        }
        if (source.sorts() != null) {
            try {
                Optional<SortAndFormats> optionalSort = SortBuilder.buildSort(source.sorts(), context.getQueryShardContext());
                if (optionalSort.isPresent()) {
                    context.sort(optionalSort.get());
                }
            }
            catch (IOException e) {
                throw new SearchContextException(context, "failed to create sort elements", (Throwable)e);
            }
        }
        context.trackScores(source.trackScores());
        if (source.minScore() != null) {
            context.minimumScore(source.minScore().floatValue());
        }
        if (source.profile()) {
            context.setProfilers(new Profilers(context.searcher()));
        }
        if (source.timeout() != null) {
            context.timeout(source.timeout());
        }
        context.terminateAfter(source.terminateAfter());
        if (source.aggregations() != null) {
            try {
                AggregatorFactories factories = source.aggregations().build(context, null);
                factories.validate();
                context.aggregations(new SearchContextAggregations(factories));
            }
            catch (IOException e) {
                throw new AggregationInitializationException("Failed to create aggregators", e);
            }
        }
        if (source.suggest() != null) {
            try {
                context.suggest(source.suggest().build(queryShardContext));
            }
            catch (IOException e) {
                throw new SearchContextException(context, "failed to create SuggestionSearchContext", (Throwable)e);
            }
        }
        if (source.rescores() != null) {
            try {
                for (RescoreBuilder rescore : source.rescores()) {
                    context.addRescore(rescore.build(queryShardContext));
                }
            }
            catch (IOException e) {
                throw new SearchContextException(context, "failed to create RescoreSearchContext", (Throwable)e);
            }
        }
        if (source.explain() != null) {
            context.explain(source.explain());
        }
        if (source.fetchSource() != null) {
            context.fetchSourceContext(source.fetchSource());
        }
        if (source.docValueFields() != null) {
            context.docValueFieldsContext(new DocValueFieldsContext(source.docValueFields()));
        }
        if (source.highlighter() != null) {
            Iterator<SearchExtBuilder> highlightBuilder = source.highlighter();
            try {
                context.highlight(((HighlightBuilder)((Object)highlightBuilder)).build(queryShardContext));
            }
            catch (IOException e) {
                throw new SearchContextException(context, "failed to create SearchContextHighlighter", (Throwable)e);
            }
        }
        if (source.scriptFields() != null) {
            for (SearchSourceBuilder.ScriptField field : source.scriptFields()) {
                SearchScript searchScript = this.scriptService.search(context.lookup(), field.script(), ScriptContext.Standard.SEARCH);
                context.scriptFields().add(new ScriptFieldsContext.ScriptField(field.fieldName(), searchScript, field.ignoreFailure()));
            }
        }
        if (source.ext() != null) {
            for (SearchExtBuilder searchExtBuilder : source.ext()) {
                context.addSearchExt(searchExtBuilder);
            }
        }
        if (source.version() != null) {
            context.version(source.version());
        }
        if (source.stats() != null) {
            context.groupStats(source.stats());
        }
        if (source.searchAfter() != null && source.searchAfter().length > 0) {
            if (context.scrollContext() != null) {
                throw new SearchContextException(context, "`search_after` cannot be used in a scroll context.");
            }
            if (context.from() > 0) {
                throw new SearchContextException(context, "`from` parameter must be set to 0 when `search_after` is used.");
            }
            FieldDoc fieldDoc = SearchAfterBuilder.buildFieldDoc(context.sort(), source.searchAfter());
            context.searchAfter(fieldDoc);
        }
        if (source.slice() != null) {
            if (context.scrollContext() == null) {
                throw new SearchContextException(context, "`slice` cannot be used outside of a scroll context");
            }
            context.sliceBuilder(source.slice());
        }
        if (source.storedFields() != null) {
            if (!source.storedFields().fetchFields()) {
                if (context.version()) {
                    throw new SearchContextException(context, "`stored_fields` cannot be disabled if version is requested");
                }
                if (context.sourceRequested()) {
                    throw new SearchContextException(context, "`stored_fields` cannot be disabled if _source is requested");
                }
            }
            context.storedFieldsContext(source.storedFields());
        }
        if (source.collapse() != null) {
            CollapseContext collapseContext = source.collapse().build(context);
            context.collapse(collapseContext);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void shortcutDocIdsToLoad(SearchContext context) {
        int[] docIdsToLoad;
        TopDocs topDocs;
        List<Object> completionSuggestions;
        int docsOffset = 0;
        Suggest suggest = context.queryResult().suggest();
        int numSuggestDocs = 0;
        if (suggest != null && suggest.hasScoreDocs()) {
            completionSuggestions = suggest.filter(CompletionSuggestion.class);
            for (CompletionSuggestion completionSuggestion : completionSuggestions) {
                numSuggestDocs += completionSuggestion.getOptions().size();
            }
        } else {
            completionSuggestions = Collections.emptyList();
        }
        if (context.request().scroll() != null) {
            void var8_9;
            topDocs = context.queryResult().topDocs();
            docIdsToLoad = new int[topDocs.scoreDocs.length + numSuggestDocs];
            boolean bl = false;
            while (var8_9 < topDocs.scoreDocs.length) {
                docIdsToLoad[docsOffset++] = topDocs.scoreDocs[var8_9].doc;
                ++var8_9;
            }
        } else {
            topDocs = context.queryResult().topDocs();
            if (topDocs.scoreDocs.length < context.from()) {
                docIdsToLoad = new int[numSuggestDocs];
            } else {
                int n = context.from() + context.size();
                docIdsToLoad = new int[Math.min(topDocs.scoreDocs.length - context.from(), context.size()) + numSuggestDocs];
                for (int i = context.from(); i < Math.min(n, topDocs.scoreDocs.length); ++i) {
                    docIdsToLoad[docsOffset++] = topDocs.scoreDocs[i].doc;
                }
            }
        }
        for (CompletionSuggestion completionSuggestion : completionSuggestions) {
            for (CompletionSuggestion.Entry.Option option : completionSuggestion.getOptions()) {
                docIdsToLoad[docsOffset++] = option.getDoc().doc;
            }
        }
        context.docIdsToLoad(docIdsToLoad, 0, docIdsToLoad.length);
    }

    private void processScroll(InternalScrollSearchRequest request, SearchContext context) {
        context.from(context.from() + context.size());
        context.scrollContext().scroll = request.scroll();
        if (request.scroll() != null && request.scroll().keepAlive() != null) {
            context.keepAlive(request.scroll().keepAlive().millis());
        }
    }

    public int getActiveContexts() {
        return this.activeContexts.size();
    }

    public AliasFilter buildAliasFilter(ClusterState state, String index, String ... expressions) {
        return this.indicesService.buildAliasFilter(state, index, expressions);
    }

    public boolean canMatch(ShardSearchRequest request) throws IOException {
        assert (request.searchType() == SearchType.QUERY_THEN_FETCH) : "unexpected search type: " + (Object)((Object)request.searchType());
        try (DefaultSearchContext context = this.createSearchContext(request, this.defaultSearchTimeout, null);){
            SearchSourceBuilder source = context.request().source();
            if (SearchService.canRewriteToMatchNone(source)) {
                QueryBuilder queryBuilder = source.query();
                boolean bl = !(queryBuilder instanceof MatchNoneQueryBuilder);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public static boolean canRewriteToMatchNone(SearchSourceBuilder source) {
        if (source == null || source.query() == null || source.query() instanceof MatchAllQueryBuilder || source.suggest() != null) {
            return false;
        }
        AggregatorFactories.Builder aggregations = source.aggregations();
        return aggregations == null || !aggregations.mustVisitAllDocs();
    }

    class Reaper
    implements Runnable {
        Reaper() {
        }

        @Override
        public void run() {
            long time = SearchService.this.threadPool.relativeTimeInMillis();
            for (SearchContext context : SearchService.this.activeContexts.values()) {
                long lastAccessTime = context.lastAccessTime();
                if (lastAccessTime == -1L || time - lastAccessTime <= context.keepAlive()) continue;
                SearchService.this.logger.debug("freeing search context [{}], time [{}], lastAccessTime [{}], keepAlive [{}]", (Object)context.id(), (Object)time, (Object)lastAccessTime, (Object)context.keepAlive());
                SearchService.this.freeContext(context.id());
            }
        }
    }
}

