/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.kafka;

import java.util.HashMap;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.runtime.Cacheable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="KafkaWorkItem.wid", name="KafkaPublishMessages", displayName="KafkaPublishMessages", defaultHandler="mvel: new org.jbpm.process.workitem.kafka.KafkaWorkItemHandler(\"bootstrapServers\", \"clientId\", \"keySerializerClass\", \"valueSerializerClass\")", documentation="kafka-workitem/index.html", category="kafka-workitem", icon="KafkaPublishMessages.png", parameters={@WidParameter(name="Topic", required=true), @WidParameter(name="Key", required=true), @WidParameter(name="Value", required=true)}, results={@WidResult(name="Result")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="kafka-workitem", version="7.47.0.Final")}, serviceInfo=@WidService(category="Kafka", description="publish kafka messages from a process", keywords="kafka,publish,message,topic", action=@WidAction(title="Publish message to a kafka topic"), authinfo=@WidAuth(required=true, params={"bootstrapServers", "clientId", "keySerializerClass", "valueSerializerClass"}, paramsdescription={"Bootstrap Servers", "Client ID", "Key Serializer class", "Value Serializer class"}, referencesite="https://kafka.apache.org/10/javadoc/org/apache/kafka/clients/producer/KafkaProducer.html")))
public class KafkaWorkItemHandler
extends AbstractLogOrThrowWorkItemHandler
implements Cacheable {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaWorkItemHandler.class);
    private Producer<String, String> producer;
    private static final String RESULTS_VALUE = "Result";

    public KafkaWorkItemHandler(Producer producer) {
        this.producer = producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KafkaWorkItemHandler(String bootstrapServers, String clientId, String keySerializerClass, String valueSerializerClass, ClassLoader classLoader) {
        Properties config = new Properties();
        config.put("bootstrap.servers", bootstrapServers);
        config.put("client.id", clientId);
        config.put("key.serializer", keySerializerClass);
        config.put("value.serializer", valueSerializerClass);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            this.producer = new KafkaProducer(config);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public KafkaWorkItemHandler(String bootstrapServers, String clientId, String keySerializerClass, String valueSerializerClass) {
        this(bootstrapServers, clientId, keySerializerClass, valueSerializerClass, KafkaProducer.class.getClassLoader());
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            HashMap<String, String> results = new HashMap<String, String>();
            String topic = (String)workItem.getParameter("Topic");
            Object key = workItem.getParameter("Key");
            Object value = workItem.getParameter("Value");
            this.producer.send(new ProducerRecord(topic, key, value)).get();
            results.put(RESULTS_VALUE, "success");
            manager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception exp) {
            LOG.error("Handler error", (Throwable)exp);
            this.handleException(exp);
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    public void close() {
        if (this.producer != null) {
            this.producer.flush();
            this.producer.close();
        }
    }
}

