/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.backend.server.indexing;

import java.util.List;
import org.jboss.forge.roaster.model.Type;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.EnumConstantSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.Import;
import org.jboss.forge.roaster.model.source.JavaAnnotationSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaEnumSource;
import org.jboss.forge.roaster.model.source.JavaInterfaceSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.source.ParameterSource;
import org.kie.soup.project.datamodel.commons.types.ClassTypeResolver;
import org.kie.workbench.common.services.datamodeller.util.DriverUtils;
import org.kie.workbench.common.services.refactoring.Resource;
import org.kie.workbench.common.services.refactoring.backend.server.impact.ResourceReferenceCollector;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSourceVisitor
extends ResourceReferenceCollector {
    private static final Logger logger = LoggerFactory.getLogger(JavaSourceVisitor.class);
    private final JavaSource javaSource;
    private final ClassTypeResolver classTypeResolver;
    private final Resource resParts;

    public JavaSourceVisitor(JavaSource javaSource, ClassLoader classLoader, Resource resParts) {
        this.javaSource = javaSource;
        this.classTypeResolver = DriverUtils.createClassTypeResolver((JavaSource)javaSource, (ClassLoader)classLoader);
        this.resParts = resParts;
    }

    public void visit(JavaSource javaSource) {
        List imports = javaSource.getImports();
        for (Import javaImport : imports) {
            this.visit(javaImport);
        }
        if (javaSource instanceof EnumConstantSource.Body) {
            this.visit((EnumConstantSource.Body)javaSource);
        } else if (javaSource instanceof JavaAnnotationSource) {
            this.visit((JavaAnnotationSource)javaSource);
        } else if (javaSource instanceof JavaClassSource) {
            this.visit((JavaClassSource)javaSource);
        } else if (javaSource instanceof JavaEnumSource) {
            this.visit((JavaEnumSource)javaSource);
        } else if (javaSource instanceof JavaInterfaceSource) {
            this.visit((JavaInterfaceSource)javaSource);
        }
    }

    public void visit(AnnotationSource<? extends JavaClassSource> annoSource) {
        this.addJavaResourceReference(annoSource.getQualifiedName());
    }

    public void visit(EnumConstantSource.Body body) {
        for (AnnotationSource annoSource : body.getAnnotations()) {
            this.visit((AnnotationSource<? extends JavaClassSource>)annoSource);
        }
        for (FieldSource fieldSource : body.getFields()) {
            this.visit((FieldSource<? extends JavaSource>)fieldSource);
        }
        for (MethodSource methodSource : body.getMethods()) {
            this.visit((MethodSource<? extends JavaClassSource>)methodSource);
        }
    }

    public void visit(FieldSource<? extends JavaSource> fieldSource) {
        Type fieldType = fieldSource.getType();
        String fieldName = fieldSource.getName();
        this.resParts.addPart(fieldName, PartType.FIELD);
        try {
            String fieldClassName;
            if (DriverUtils.isManagedType((Type)fieldType, (ClassTypeResolver)this.classTypeResolver)) {
                if (fieldType.isPrimitive()) {
                    fieldClassName = fieldType.getName();
                } else if (DriverUtils.isSimpleClass((Type)fieldType)) {
                    fieldClassName = this.classTypeResolver.getFullTypeName(fieldType.getName());
                } else {
                    Type elementsType = (Type)fieldType.getTypeArguments().get(0);
                    fieldClassName = this.classTypeResolver.getFullTypeName(elementsType.getName());
                }
            } else {
                fieldClassName = fieldType.getQualifiedName();
            }
            this.addJavaResourceReference(fieldClassName);
        }
        catch (Exception e) {
            logger.error("Unable to index java class field for class: " + this.javaSource.getQualifiedName() + ", fieldName: " + fieldName + ", fieldType: " + fieldType, (Throwable)e);
        }
        for (AnnotationSource annoSource : fieldSource.getAnnotations()) {
            this.visit((AnnotationSource<? extends JavaClassSource>)annoSource);
        }
    }

    public void visit(JavaAnnotationSource javaAnnoSource) {
        for (AnnotationSource annoSource : javaAnnoSource.getAnnotations()) {
            this.visit((AnnotationSource<? extends JavaClassSource>)annoSource);
        }
    }

    public void visit(JavaClassSource javaClassSource) {
        List implementedInterfaces;
        if (javaClassSource.getSuperType() != null) {
            try {
                String superClass = this.classTypeResolver.getFullTypeName(javaClassSource.getSuperType());
                this.addJavaResourceReference(superClass);
            }
            catch (ClassNotFoundException e) {
                logger.error("Unable to index superclass name for class: " + javaClassSource.getQualifiedName() + ", superclass: " + javaClassSource.getSuperType(), (Throwable)e);
            }
        }
        if ((implementedInterfaces = javaClassSource.getInterfaces()) != null) {
            for (String implementedInterface : implementedInterfaces) {
                try {
                    implementedInterface = this.classTypeResolver.getFullTypeName(javaClassSource.resolveType(implementedInterface));
                    this.addJavaResourceReference(implementedInterface);
                }
                catch (ClassNotFoundException e) {
                    logger.error("Unable to index implemented interface qualified name for class: " + javaClassSource.getQualifiedName() + ", interface: " + implementedInterface, (Throwable)e);
                }
            }
        }
        for (AnnotationSource annoSource : javaClassSource.getAnnotations()) {
            this.visit((AnnotationSource<? extends JavaClassSource>)annoSource);
        }
        for (FieldSource fieldSource : javaClassSource.getFields()) {
            this.visit((FieldSource<? extends JavaSource>)fieldSource);
        }
        for (MethodSource methodSource : javaClassSource.getMethods()) {
            this.visit((MethodSource<? extends JavaClassSource>)methodSource);
        }
    }

    public void visit(JavaEnumSource javaEnumSource) {
        for (AnnotationSource annoSource : javaEnumSource.getAnnotations()) {
            this.visit((AnnotationSource<? extends JavaClassSource>)annoSource);
        }
        for (FieldSource fieldSource : javaEnumSource.getFields()) {
            this.visit((FieldSource<? extends JavaSource>)fieldSource);
        }
        for (MethodSource methodSource : javaEnumSource.getMethods()) {
            this.visit((MethodSource<? extends JavaClassSource>)methodSource);
        }
    }

    public void visit(Import javaImport) {
        String refClassName = javaImport.getQualifiedName();
        if (javaImport.isWildcard()) {
            logger.warn("Import " + javaImport.getQualifiedName() + " used in class.");
        } else {
            this.addJavaResourceReference(refClassName);
        }
    }

    public void visit(JavaInterfaceSource interfaceSource) {
        for (AnnotationSource annoSource : interfaceSource.getAnnotations()) {
            this.visit((AnnotationSource<? extends JavaClassSource>)annoSource);
        }
        for (FieldSource fieldSource : interfaceSource.getFields()) {
            this.visit((FieldSource<? extends JavaSource>)fieldSource);
        }
        for (MethodSource methodSource : interfaceSource.getMethods()) {
            this.visit((MethodSource<? extends JavaClassSource>)methodSource);
        }
    }

    public void visit(MethodSource<? extends JavaClassSource> methodSource) {
        String returnTypeQualifiedName;
        for (ParameterSource paramSource : methodSource.getParameters()) {
            this.addJavaResourceReference(paramSource.getType().getQualifiedName());
            for (AnnotationSource annoSource : paramSource.getAnnotations()) {
                this.visit((AnnotationSource<? extends JavaClassSource>)annoSource);
            }
        }
        Type returnType = methodSource.getReturnType();
        if (returnType != null && !(returnTypeQualifiedName = returnType.getQualifiedName()).endsWith(".void")) {
            this.addJavaResourceReference(returnTypeQualifiedName);
        }
        for (AnnotationSource annoSource : methodSource.getAnnotations()) {
            this.visit((AnnotationSource<? extends JavaClassSource>)annoSource);
        }
    }

    public void addJavaResourceReference(String fullyQualifiedName) {
        super.addResourceReference(fullyQualifiedName, ResourceType.JAVA);
    }
}

