/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server.builder.projects;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.kie.soup.project.datamodel.commons.oracle.ModuleDataModelOracleImpl;
import org.kie.soup.project.datamodel.commons.util.MVELEvaluator;
import org.kie.soup.project.datamodel.oracle.ModuleDataModelOracle;
import org.kie.soup.project.datamodel.oracle.TypeSource;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.ClassFactBuilder;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.FactBuilder;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.SimpleFactBuilder;
import org.kie.workbench.common.services.datamodel.backend.server.builder.util.DataEnumLoader;

public final class ModuleDataModelOracleBuilder {
    private ModuleDataModelOracleImpl oracle = new ModuleDataModelOracleImpl();
    private Map<String, FactBuilder> factTypeBuilders = new HashMap<String, FactBuilder>();
    private Map<String, String[]> factFieldEnums = new HashMap<String, String[]>();
    private List<String> packageNames = new ArrayList<String>();
    private final Map<String, FactBuilder> discoveredFieldFactBuilders = new HashMap<String, FactBuilder>();
    private List<String> errors = new ArrayList<String>();
    private MVELEvaluator evaluator;

    public static ModuleDataModelOracleBuilder newModuleOracleBuilder(MVELEvaluator evaluator) {
        return new ModuleDataModelOracleBuilder(evaluator);
    }

    private ModuleDataModelOracleBuilder(MVELEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public SimpleFactBuilder addFact(String factType) {
        return this.addFact(factType, false);
    }

    public SimpleFactBuilder addFact(String factType, boolean isEvent) {
        return this.addFact(factType, isEvent, TypeSource.JAVA_PROJECT);
    }

    public SimpleFactBuilder addFact(String factType, boolean isEvent, TypeSource typeSource) {
        SimpleFactBuilder builder = new SimpleFactBuilder(this, factType, isEvent, type -> typeSource);
        this.factTypeBuilders.put(factType, builder);
        return builder;
    }

    public ModuleDataModelOracleBuilder addClass(Class clazz) throws IOException {
        return this.addClass(clazz, false);
    }

    public ModuleDataModelOracleBuilder addClass(Class clazz, boolean isEvent) throws IOException {
        return this.addClass(clazz, isEvent, type -> TypeSource.JAVA_PROJECT);
    }

    public ModuleDataModelOracleBuilder addClass(Class clazz, boolean isEvent, Function<String, TypeSource> resolver) throws IOException {
        ClassFactBuilder builder = new ClassFactBuilder(this, this.discoveredFieldFactBuilders, clazz, isEvent, resolver);
        this.factTypeBuilders.put(clazz.getName(), builder);
        return this;
    }

    public ModuleDataModelOracleBuilder addEnum(String factType, String fieldName, String[] values) {
        String qualifiedFactField = factType + "#" + fieldName;
        this.factFieldEnums.put(qualifiedFactField, values);
        return this;
    }

    public ModuleDataModelOracleBuilder addEnum(String enumDefinition, ClassLoader classLoader) {
        this.parseEnumDefinition(enumDefinition, classLoader, this.evaluator);
        return this;
    }

    private void parseEnumDefinition(String enumDefinition, ClassLoader classLoader, MVELEvaluator evaluator) {
        DataEnumLoader enumLoader = new DataEnumLoader(enumDefinition, classLoader, evaluator);
        if (enumLoader.hasErrors()) {
            this.logEnumErrors(enumLoader);
        } else {
            this.factFieldEnums.putAll(enumLoader.getData());
        }
    }

    private void logEnumErrors(DataEnumLoader enumLoader) {
        this.errors.addAll(enumLoader.getErrors());
    }

    public ModuleDataModelOracle build() {
        this.loadFactTypes();
        this.loadEnums();
        this.loadPackageNames();
        return this.oracle;
    }

    private void loadPackageNames() {
        this.oracle.addModulePackageNames(this.packageNames);
    }

    private void loadFactTypes() {
        HashMap<String, FactBuilder> builders = new HashMap<String, FactBuilder>();
        this.factTypeBuilders.entrySet().stream().filter(e -> !builders.containsKey(e.getKey())).forEach(entry -> {
            builders.put((String)entry.getKey(), (FactBuilder)entry.getValue());
            ((FactBuilder)entry.getValue()).addInternalBuilders(builders);
        });
        this.factTypeBuilders = builders;
        for (FactBuilder factBuilder : this.factTypeBuilders.values()) {
            factBuilder.build(this.oracle);
        }
    }

    private void loadEnums() {
        HashMap<String, String[]> loadableEnums = new HashMap<String, String[]>();
        for (Map.Entry<String, String[]> e : this.factFieldEnums.entrySet()) {
            String qualifiedFactField = e.getKey();
            loadableEnums.put(qualifiedFactField, e.getValue());
        }
        this.oracle.addModuleJavaEnumDefinitions(loadableEnums);
    }

    public void addPackage(String packageName) {
        this.packageNames.add(packageName);
    }

    public void addPackages(Collection<String> packageNames) {
        this.packageNames.addAll(packageNames);
    }
}

