/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server.conversion;

import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.BRLColumnDataBuilder;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.DataBuilder;

public class BRLColumnDataBuilderDefault
implements BRLColumnDataBuilder {
    private final DataBuilder.DataRowBuilder dataRowBuilder;

    public BRLColumnDataBuilderDefault(DataBuilder.DataRowBuilder dataRowBuilder) {
        this.dataRowBuilder = dataRowBuilder;
    }

    @Override
    public void build(BRLActionColumn brlColumn, List<DTCellValue52> row, Row xlsRow) {
        this.addColumnValuesToRow(xlsRow, new CombinedValueProvider(row, (BRLColumn)brlColumn, false));
    }

    @Override
    public void build(BRLConditionColumn brlColumn, List<DTCellValue52> row, Row xlsRow) {
        this.addColumnValuesToRow(xlsRow, new CombinedValueProvider(row, (BRLColumn)brlColumn, true));
    }

    private void addColumnValuesToRow(Row xlsRow, CombinedValueProvider combinedValueProvider) {
        if (combinedValueProvider.isContentValid()) {
            xlsRow.createCell(this.dataRowBuilder.getTargetColumnIndex()).setCellValue(combinedValueProvider.getValue());
        }
    }

    class CombinedValueProvider {
        private final String value;
        private boolean isContentValid = false;
        private final List<DTCellValue52> row;
        private final boolean missingVariable;
        private final int amountOfChildColumns;
        private final boolean trimQuotesOff;

        public CombinedValueProvider(List<DTCellValue52> row, BRLColumn brlColumn, boolean trimQuotesOff) {
            this.row = row;
            this.missingVariable = this.isMissingVariable(brlColumn);
            this.amountOfChildColumns = brlColumn.getChildColumns().size();
            this.trimQuotesOff = trimQuotesOff;
            this.value = this.build();
        }

        public String getValue() {
            return this.value;
        }

        public boolean isContentValid() {
            return this.isContentValid;
        }

        private String build() {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < this.amountOfChildColumns; ++i) {
                String cellValue = BRLColumnDataBuilderDefault.this.dataRowBuilder.getValue(this.row, BRLColumnDataBuilderDefault.this.dataRowBuilder.getSourceColumnIndex());
                if (cellValue != null && this.missingVariable) {
                    if (!BooleanUtils.toBoolean((String)cellValue.toLowerCase())) break;
                    result.append("X");
                    this.isContentValid = true;
                    break;
                }
                if (StringUtils.isNotEmpty((CharSequence)cellValue)) {
                    result.append(this.trimQuotesOff(cellValue));
                    this.isContentValid = true;
                }
                if (i >= this.amountOfChildColumns - 1) continue;
                result.append(", ");
                BRLColumnDataBuilderDefault.this.dataRowBuilder.moveSourceColumnIndexForward();
            }
            return result.toString();
        }

        private boolean isMissingVariable(BRLColumn brlColumn) {
            for (Object childColumn : brlColumn.getChildColumns()) {
                if (this.getVariableName(childColumn).isEmpty()) continue;
                return false;
            }
            return true;
        }

        private String getVariableName(Object childColumn) {
            if (childColumn instanceof BRLActionVariableColumn) {
                return ((BRLActionVariableColumn)childColumn).getVarName();
            }
            if (childColumn instanceof BRLConditionVariableColumn) {
                return ((BRLConditionVariableColumn)childColumn).getVarName();
            }
            return "";
        }

        private String trimQuotesOff(String value) {
            if (this.trimQuotesOff && this.isSurroundedByQuotes(value)) {
                return value.substring(1, value.length() - 1);
            }
            return value;
        }

        private boolean isSurroundedByQuotes(String value) {
            return StringUtils.isNotEmpty((CharSequence)value) && value.length() >= 2 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"';
        }
    }
}

