/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.exception.BadCommandArgumentsException;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.RegisterNodeCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.rule.context.CardinalityContext;

@Portable
public class DeregisterNodeCommand
extends AbstractGraphCommand {
    private static Logger LOGGER = Logger.getLogger(DeregisterNodeCommand.class.getName());
    protected final String uuid;
    transient Node<?, Edge> node;
    transient Node<?, Edge> removed;

    public DeregisterNodeCommand(@MapsTo(value="uuid") String uuid) {
        this.uuid = (String)PortablePreconditions.checkNotNull((String)"uuid", (Object)uuid);
        this.removed = null;
    }

    public DeregisterNodeCommand(Node<?, Edge> node) {
        this(node.getUUID());
        this.node = node;
    }

    public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
        CommandResult<RuleViolation> results = this.allow(context);
        if (!results.getType().equals((Object)CommandResult.Type.ERROR)) {
            LOGGER.log(Level.FINE, "Executing...");
            Graph<?, Node> graph = this.getGraph(context);
            Node<?, Edge> candidate = this.getCandidate(context);
            this.removed = candidate;
            graph.removeNode(candidate.getUUID());
            this.getMutableIndex(context).removeNode(candidate);
            LOGGER.log(Level.FINE, "Node [" + this.uuid + " removed from strcture and index.");
        }
        return results;
    }

    public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
        RegisterNodeCommand undoCommand = new RegisterNodeCommand(this.removed);
        return undoCommand.execute(context);
    }

    @Override
    protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
        Node<?, Edge> candidate = this.checkCandidateNotNull(context);
        GraphCommandResultBuilder builder = new GraphCommandResultBuilder();
        Collection<RuleViolation> cardinalityRuleViolations = this.evaluate(context, contextBuilder -> contextBuilder.cardinality(Collections.singleton(candidate), CardinalityContext.Operation.DELETE));
        builder.addViolations(cardinalityRuleViolations);
        return builder.build();
    }

    public Node<?, Edge> getNode() {
        return this.node;
    }

    public Node<?, Edge> getRemoved() {
        return this.removed;
    }

    protected Node<?, Edge> getCandidate(GraphCommandExecutionContext context) {
        if (null == this.node) {
            this.node = this.getNode(context, this.uuid);
        }
        return this.node;
    }

    protected Node<?, Edge> checkCandidateNotNull(GraphCommandExecutionContext context) {
        Node<?, Edge> e = this.getCandidate(context);
        if (null == e) {
            throw new BadCommandArgumentsException((Command)this, (Object)this.uuid, "Node not found for [" + this.uuid + "].");
        }
        return e;
    }

    public String toString() {
        return "DeregisterNodeCommand [candidate=" + this.uuid + "]";
    }
}

