/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.validation.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.AbstractTreeTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessor;
import org.kie.workbench.common.stunner.core.rule.RuleEvaluationContext;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.kie.workbench.common.stunner.core.rule.RuleSet;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;
import org.kie.workbench.common.stunner.core.rule.context.EdgeCardinalityContext;
import org.kie.workbench.common.stunner.core.rule.context.impl.RuleEvaluationContextBuilder;
import org.kie.workbench.common.stunner.core.rule.violations.EmptyConnectionViolation;
import org.kie.workbench.common.stunner.core.validation.GraphValidator;

@ApplicationScoped
public class GraphValidatorImpl
implements GraphValidator<Graph, RuleViolation> {
    private final DefinitionManager definitionManager;
    private final TreeWalkTraverseProcessor treeWalkTraverseProcessor;
    private final RuleManager ruleManager;

    protected GraphValidatorImpl() {
        this(null, null, null);
    }

    @Inject
    public GraphValidatorImpl(DefinitionManager definitionManager, RuleManager ruleManager, TreeWalkTraverseProcessor treeWalkTraverseProcessor) {
        this.definitionManager = definitionManager;
        this.ruleManager = ruleManager;
        this.treeWalkTraverseProcessor = treeWalkTraverseProcessor;
    }

    public void validate(Graph graph, Consumer<Collection<RuleViolation>> callback) {
        this.validate(graph, null, callback);
    }

    public void validate(Graph graph, RuleSet ruleSet, Consumer<Collection<RuleViolation>> callback) {
        this.validate(graph, Optional.ofNullable(ruleSet), Optional.empty(), Optional.empty(), Optional.empty(), callback);
    }

    void validate(final Graph graph, Optional<RuleSet> aRuleSet, final Optional<BiConsumer<Graph, Collection<RuleViolation>>> graphValidatorConsumer, final Optional<BiConsumer<Node, Collection<RuleViolation>>> nodeValidatorConsumer, final Optional<BiConsumer<Edge, Collection<RuleViolation>>> edgeValidatorConsumer, final Consumer<Collection<RuleViolation>> resultConsumer) {
        final RuleSet ruleSet = aRuleSet.orElse(this.getRuleSet(graph));
        final ViolationsSet violations = new ViolationsSet();
        final RuleEvaluationContextBuilder.StatelessGraphContextBuilder contextBuilder = new RuleEvaluationContextBuilder.StatelessGraphContextBuilder(graph);
        this.treeWalkTraverseProcessor.traverse((Object)graph, (Object)new AbstractTreeTraverseCallback<Graph, Node, Edge>(){
            private final Stack<Node> currentParents = new Stack();

            @Override
            public void startGraphTraversal(Graph graph2) {
                super.startGraphTraversal(graph2);
                this.currentParents.clear();
                Set<RuleViolation> graphCardinalityViolations = violations.addViolations(GraphValidatorImpl.this.evaluateCardinality(contextBuilder, ruleSet));
                graphValidatorConsumer.ifPresent(g -> g.accept(graph2, graphCardinalityViolations));
            }

            @Override
            public boolean startEdgeTraversal(Edge edge) {
                super.startEdgeTraversal(edge);
                Object content = edge.getContent();
                ViolationsSet edgeViolations = new ViolationsSet();
                if (content instanceof Child) {
                    this.currentParents.push(edge.getSourceNode());
                } else if (content instanceof View) {
                    Optional<Node> sourceOpt = Optional.ofNullable(edge.getSourceNode());
                    Optional<Node> targetOpt = Optional.ofNullable(edge.getTargetNode());
                    Optional emptyConnectionViolation = GraphValidatorImpl.this.evaluateNotEmptyConnections(edge, sourceOpt, targetOpt);
                    emptyConnectionViolation.ifPresent(edgeViolations::add);
                    edgeViolations.addViolations(GraphValidatorImpl.this.evaluateConnection(contextBuilder, ruleSet, edge, sourceOpt, targetOpt));
                    if (null != edge.getTargetNode()) {
                        edgeViolations.addViolations(GraphValidatorImpl.this.evaluateIncomingEdgeCardinality(contextBuilder, ruleSet, (Edge<? extends View, Node>)edge));
                    }
                    if (null != edge.getSourceNode()) {
                        edgeViolations.addViolations(GraphValidatorImpl.this.evaluateOutgoingEdgeCardinality(contextBuilder, ruleSet, (Edge<? extends View, Node>)edge));
                    }
                } else if (content instanceof Dock) {
                    Node parent = edge.getSourceNode();
                    Node docked = edge.getTargetNode();
                    edgeViolations.addViolations(GraphValidatorImpl.this.evaluateDocking(contextBuilder, ruleSet, (Element)parent, docked));
                }
                edgeValidatorConsumer.ifPresent(c -> c.accept(edge, edgeViolations));
                violations.addAll(edgeViolations);
                return true;
            }

            @Override
            public void endEdgeTraversal(Edge edge) {
                super.endEdgeTraversal(edge);
                if (edge.getContent() instanceof Child) {
                    this.currentParents.pop();
                }
            }

            @Override
            public boolean startNodeTraversal(Node node) {
                super.startNodeTraversal(node);
                Collection<RuleViolation> nodeViolations = this.evaluateNode(node, this.currentParents.isEmpty() ? null : this.currentParents.peek());
                nodeValidatorConsumer.ifPresent(c -> c.accept(node, nodeViolations));
                return true;
            }

            @Override
            public void endGraphTraversal() {
                super.endGraphTraversal();
                resultConsumer.accept(violations);
            }

            private Collection<RuleViolation> evaluateNode(Node node, Node parent) {
                return violations.addViolations(GraphValidatorImpl.this.evaluateContainment(ruleSet, contextBuilder, (Element)(null != parent ? parent : graph), node));
            }
        });
    }

    private RuleSet getRuleSet(Graph<? extends DefinitionSet, ?> graph) {
        String defSetId = (String)((DefinitionSet)graph.getContent()).getDefinition();
        Object definitionSet = this.definitionManager.definitionSets().getDefinitionSetById(defSetId);
        return this.definitionManager.adapters().forRules().getRuleSet(definitionSet);
    }

    private RuleViolations evaluateContainment(RuleSet ruleSet, RuleEvaluationContextBuilder.StatelessGraphContextBuilder contextBuilder, Element<? extends Definition<?>> parent, Node candidate) {
        return this.ruleManager.evaluate(ruleSet, (RuleEvaluationContext)contextBuilder.containment(parent, candidate));
    }

    private RuleViolations evaluateCardinality(RuleEvaluationContextBuilder.StatelessGraphContextBuilder contextBuilder, RuleSet ruleSet) {
        return this.ruleManager.evaluate(ruleSet, (RuleEvaluationContext)contextBuilder.graphCardinality());
    }

    private RuleViolations evaluateDocking(RuleEvaluationContextBuilder.StatelessGraphContextBuilder contextBuilder, RuleSet ruleSet, Element<? extends Definition<?>> parent, Node candidate) {
        return this.ruleManager.evaluate(ruleSet, (RuleEvaluationContext)contextBuilder.docking(parent, candidate));
    }

    private Optional<RuleViolation> evaluateNotEmptyConnections(Edge<? extends View<?>, ? extends Node> connector, Optional<Node<? extends View<?>, ? extends Edge>> sourceNode, Optional<Node<? extends View<?>, ? extends Edge>> targetNode) {
        if (!sourceNode.isPresent() || !targetNode.isPresent()) {
            return Optional.of(EmptyConnectionViolation.Builder.build(connector, sourceNode, targetNode));
        }
        return Optional.empty();
    }

    private RuleViolations evaluateConnection(RuleEvaluationContextBuilder.StatelessGraphContextBuilder contextBuilder, RuleSet ruleSet, Edge<? extends View<?>, ? extends Node> connector, Optional<Node<? extends View<?>, ? extends Edge>> sourceNode, Optional<Node<? extends View<?>, ? extends Edge>> targetNode) {
        return this.ruleManager.evaluate(ruleSet, (RuleEvaluationContext)contextBuilder.connection(connector, sourceNode, targetNode));
    }

    private RuleViolations evaluateIncomingEdgeCardinality(RuleEvaluationContextBuilder.StatelessGraphContextBuilder contextBuilder, RuleSet ruleSet, Edge<? extends View, Node> edge) {
        return this.ruleManager.evaluate(ruleSet, (RuleEvaluationContext)contextBuilder.edgeCardinality((Element<? extends View<?>>)edge.getTargetNode(), (Edge<? extends View<?>, Node>)edge, EdgeCardinalityContext.Direction.INCOMING, Optional.empty()));
    }

    private RuleViolations evaluateOutgoingEdgeCardinality(RuleEvaluationContextBuilder.StatelessGraphContextBuilder contextBuilder, RuleSet ruleSet, Edge<? extends View, Node> edge) {
        return this.ruleManager.evaluate(ruleSet, (RuleEvaluationContext)contextBuilder.edgeCardinality((Element<? extends View<?>>)edge.getSourceNode(), (Edge<? extends View<?>, Node>)edge, EdgeCardinalityContext.Direction.OUTGOING, Optional.empty()));
    }

    private class ViolationsSet
    extends LinkedHashSet<RuleViolation> {
        private ViolationsSet() {
        }

        public Set<RuleViolation> addViolations(RuleViolations items) {
            LinkedHashSet<RuleViolation> result = new LinkedHashSet<RuleViolation>();
            items.violations().forEach(v -> {
                result.add((RuleViolation)v);
                this.add(v);
            });
            return result;
        }
    }
}

