/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.workbench.client.authz;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.workbench.client.resources.i18n.DefaultWorkbenchConstants;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.client.authz.tree.LoadCallback;
import org.uberfire.security.client.authz.tree.LoadOptions;
import org.uberfire.security.client.authz.tree.PermissionNode;
import org.uberfire.security.client.authz.tree.PermissionTreeProvider;
import org.uberfire.security.client.authz.tree.impl.PermissionGroupNode;
import org.uberfire.security.client.authz.tree.impl.PermissionLeafNode;

@ApplicationScoped
public class WorkbenchTreeProvider
implements PermissionTreeProvider {
    public static final String NODE_TYPE = "type";
    public static final String NODE_ROOT = "root";
    protected DefaultWorkbenchConstants i18n = DefaultWorkbenchConstants.INSTANCE;
    private PermissionManager permissionManager;
    private int rootNodePosition = 0;

    public WorkbenchTreeProvider() {
    }

    @Inject
    public WorkbenchTreeProvider(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public int getRootNodePosition() {
        return this.rootNodePosition;
    }

    public void setRootNodePosition(int rootNodePosition) {
        this.rootNodePosition = rootNodePosition;
    }

    public PermissionNode buildRootNode() {
        PermissionGroupNode rootNode = new PermissionGroupNode((PermissionTreeProvider)this);
        rootNode.setPositionInTree(this.rootNodePosition);
        rootNode.setNodeName(this.i18n.WorkbenchRootNodeName());
        rootNode.setNodeFullName(this.i18n.WorkbenchRootNodeHelp());
        rootNode.setProperty(NODE_TYPE, (Object)NODE_ROOT);
        return rootNode;
    }

    public void loadChildren(PermissionNode parent, LoadOptions options, LoadCallback callback) {
        if (parent.propertyEquals(NODE_TYPE, (Object)NODE_ROOT)) {
            callback.afterLoad(this.createPermissions());
        }
    }

    protected List<PermissionNode> createPermissions() {
        ArrayList<PermissionNode> permissions = new ArrayList<PermissionNode>();
        permissions.add((PermissionNode)this.createPermissionLeafNode("dataobject.edit", this.i18n.DataModelerEditSources(), this.i18n.DataModelerEditSourcesHelp()));
        permissions.add((PermissionNode)this.createPermissionLeafNode("planner.available", this.i18n.ResourcePlanner(), this.i18n.ResourcePlannerHelp()));
        permissions.add((PermissionNode)this.createPermissionLeafNode("jar.download", this.i18n.MavenRepositoryPagedJarTableDownloadJar(), this.i18n.MavenRepositoryPagedJarTableDownloadJarHelp()));
        permissions.add((PermissionNode)this.createPermissionLeafNode("globalpreferences.edit", this.i18n.EditGlobalPreferences(), this.i18n.EditGlobalPreferencesHelp()));
        permissions.add((PermissionNode)this.createPermissionLeafNode("guideddecisiontable.edit.columns", this.i18n.GuidedDecisionTableEditColumns(), this.i18n.GuidedDecisionTableEditColumnsHelp()));
        permissions.add((PermissionNode)this.createPermissionLeafNode("profilepreferences.edit", this.i18n.EditProfilePreferences(), this.i18n.EditProfilePreferencesHelp()));
        permissions.add((PermissionNode)this.createPermissionLeafNode("datatransfer.access", this.i18n.AccessDataTransfer(), this.i18n.AccessDataTransferHelp()));
        permissions.add((PermissionNode)this.createPermissionLeafNode("changerequesttab.show", this.i18n.ShowChangeRequestTab(), this.i18n.ShowChangeRequestTabHelp()));
        permissions.add((PermissionNode)this.createPermissionLeafNode("metricstab.show", this.i18n.ShowMetricsTab(), this.i18n.ShowMetricsTabHelp()));
        permissions.add((PermissionNode)this.createPermissionLeafNode("projecttoolbar.show", this.i18n.ShowProjectToolbar(), this.i18n.ShowProjectToolbarHelp()));
        return permissions;
    }

    protected PermissionLeafNode createPermissionLeafNode(String permissionName, String nodeName, String nodeHelp) {
        Permission permission = this.permissionManager.createPermission(permissionName, true);
        PermissionLeafNode node = new PermissionLeafNode();
        node.setNodeName(nodeName);
        node.setNodeFullName(nodeHelp);
        node.addPermission(permission, this.i18n.PermissionAllow(), this.i18n.PermissionDeny());
        return node;
    }
}

