/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.events;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.bpmn2.IntermediateThrowEvent;
import org.eclipse.bpmn2.ThrowEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.events.IntermediateThrowEventConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.FlatVariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.ThrowEventPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.definition.BaseThrowingIntermediateEvent;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateCompensationEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateEscalationEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateLinkEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateMessageEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateSignalEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.property.background.BackgroundSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.CircleDimensionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.compensation.CompensationEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.escalation.EscalationEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.escalation.EscalationRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.link.LinkEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.link.LinkRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.MessageEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.MessageRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.ScopedSignalEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.SignalRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.SignalScope;
import org.kie.workbench.common.stunner.bpmn.definition.property.font.FontSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bound;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class IntermediateThrowEventConverterTest {
    private static final String UUID = "THROWING EVENT UUID";
    private static final String NAME = "THROWING EVENT NAME";
    private static final String DOCUMENTATION = "THROWING EVENT DOCUMENTATION";
    private static final String ASSIGNMENTS_INFO = "Years of Service:Integer||Data Test:Boolean||[din]Years of Service=35,[dout]Data Test->BooleanTest";
    private ThrowEventPropertyWriter throwEventPropertyWriter;
    private PropertyWriterFactory propertyWriterFactory;
    private BPMNGeneralSet generalSet;
    private AssignmentsInfo assignmentsInfo;
    private DataIOSet dataIOSet;
    private SignalRef signalRef;
    private SignalScope signalScope;
    private LinkRef linkRef;
    private MessageRef messageRef;
    private EscalationRef escalationRef;
    private IntermediateThrowEventConverter tested;

    @Before
    public void setUp() {
        IntermediateThrowEvent throwEvent = Factories.bpmn2.createIntermediateThrowEvent();
        throwEvent.setId("throwEventID");
        this.throwEventPropertyWriter = (ThrowEventPropertyWriter)Mockito.spy((Object)new ThrowEventPropertyWriter((ThrowEvent)throwEvent, (VariableScope)new FlatVariableScope(), new HashSet()));
        this.propertyWriterFactory = (PropertyWriterFactory)Mockito.spy(PropertyWriterFactory.class);
        Mockito.when((Object)this.propertyWriterFactory.of((ThrowEvent)Matchers.any(ThrowEvent.class))).thenReturn((Object)this.throwEventPropertyWriter);
        this.generalSet = new BPMNGeneralSet(NAME, DOCUMENTATION);
        this.assignmentsInfo = new AssignmentsInfo(ASSIGNMENTS_INFO);
        this.dataIOSet = new DataIOSet(this.assignmentsInfo);
        this.signalRef = (SignalRef)Mockito.mock(SignalRef.class);
        this.signalScope = (SignalScope)Mockito.mock(SignalScope.class);
        this.linkRef = (LinkRef)Mockito.mock(LinkRef.class);
        this.messageRef = (MessageRef)Mockito.mock(MessageRef.class);
        this.escalationRef = (EscalationRef)Mockito.mock(EscalationRef.class);
        this.tested = (IntermediateThrowEventConverter)Mockito.spy((Object)new IntermediateThrowEventConverter(this.propertyWriterFactory));
    }

    @Test
    public void constructor() {
        Assert.assertEquals((Object)this.propertyWriterFactory, (Object)this.tested.propertyWriterFactory);
    }

    @Test
    public void toFlowElement() {
        Node intermediateSignalEventThrowingNode = this.createIntermediateSignalEventThrowingNode();
        Node intermediateLinkEventThrowingNode = this.createIntermediateLinkEventThrowingNode();
        Node intermediateMessageEventThrowingNode = this.createIntermediateMessageEventThrowingNode();
        Node intermediateEscalationEventThrowingNode = this.createIntermediateEscalationEventThrowingNode();
        Node intermediateCompensationEventThrowingNode = this.createIntermediateCompensationEventThrowingNode();
        this.tested.toFlowElement(intermediateSignalEventThrowingNode);
        this.tested.toFlowElement(intermediateLinkEventThrowingNode);
        this.tested.toFlowElement(intermediateMessageEventThrowingNode);
        this.tested.toFlowElement(intermediateEscalationEventThrowingNode);
        this.tested.toFlowElement(intermediateCompensationEventThrowingNode);
        ((IntermediateThrowEventConverter)Mockito.verify((Object)this.tested)).signalEvent(intermediateSignalEventThrowingNode);
        ((IntermediateThrowEventConverter)Mockito.verify((Object)this.tested)).linkEvent(intermediateLinkEventThrowingNode);
        ((IntermediateThrowEventConverter)Mockito.verify((Object)this.tested)).messageEvent(intermediateMessageEventThrowingNode);
        ((IntermediateThrowEventConverter)Mockito.verify((Object)this.tested)).escalationEvent(intermediateEscalationEventThrowingNode);
        ((IntermediateThrowEventConverter)Mockito.verify((Object)this.tested)).compensationEvent(intermediateCompensationEventThrowingNode);
    }

    @Test
    public void signalEvent() {
        Node node = this.createIntermediateSignalEventThrowingNode();
        PropertyWriter propertyWriter = this.tested.signalEvent(node);
        Assert.assertNotNull((Object)propertyWriter);
        this.verifyCommonProperties(node);
        ((ThrowEventPropertyWriter)Mockito.verify((Object)this.throwEventPropertyWriter)).addSignal(this.signalRef);
        ((ThrowEventPropertyWriter)Mockito.verify((Object)this.throwEventPropertyWriter)).addSignalScope(this.signalScope);
    }

    @Test
    public void linkEvent() {
        Node node = this.createIntermediateLinkEventThrowingNode();
        PropertyWriter propertyWriter = this.tested.linkEvent(node);
        Assert.assertNotNull((Object)propertyWriter);
        this.verifyCommonProperties(node);
        ((ThrowEventPropertyWriter)Mockito.verify((Object)this.throwEventPropertyWriter)).addLink(this.linkRef);
    }

    @Test
    public void messageEvent() {
        Node node = this.createIntermediateMessageEventThrowingNode();
        PropertyWriter propertyWriter = this.tested.messageEvent(node);
        Assert.assertNotNull((Object)propertyWriter);
        this.verifyCommonProperties(node);
        ((ThrowEventPropertyWriter)Mockito.verify((Object)this.throwEventPropertyWriter)).addMessage(this.messageRef);
    }

    @Test
    public void escalationEvent() {
        Node node = this.createIntermediateEscalationEventThrowingNode();
        PropertyWriter propertyWriter = this.tested.escalationEvent(node);
        Assert.assertNotNull((Object)propertyWriter);
        this.verifyCommonProperties(node);
        ((ThrowEventPropertyWriter)Mockito.verify((Object)this.throwEventPropertyWriter)).addEscalation(this.escalationRef);
    }

    @Test
    public void compensationEvent() {
        Node node = this.createIntermediateCompensationEventThrowingNode();
        PropertyWriter propertyWriter = this.tested.compensationEvent(node);
        Assert.assertNotNull((Object)propertyWriter);
        this.verifyCommonProperties(node);
        ((ThrowEventPropertyWriter)Mockito.verify((Object)this.throwEventPropertyWriter)).addCompensation();
    }

    private void verifyCommonProperties(Node node) {
        ((ThrowEventPropertyWriter)Mockito.verify((Object)this.throwEventPropertyWriter)).setAbsoluteBounds(node);
        ((ThrowEventPropertyWriter)Mockito.verify((Object)this.throwEventPropertyWriter)).setName(NAME);
        ((ThrowEventPropertyWriter)Mockito.verify((Object)this.throwEventPropertyWriter)).setDocumentation(DOCUMENTATION);
        ((ThrowEventPropertyWriter)Mockito.verify((Object)this.throwEventPropertyWriter)).setAssignmentsInfo(this.assignmentsInfo);
    }

    private Node createIntermediateSignalEventThrowingNode() {
        ScopedSignalEventExecutionSet executionSet = new ScopedSignalEventExecutionSet(this.signalRef, this.signalScope);
        IntermediateSignalEventThrowing eventThrowing = new IntermediateSignalEventThrowing(this.generalSet, (BackgroundSet)Mockito.mock(BackgroundSet.class), (FontSet)Mockito.mock(FontSet.class), (CircleDimensionSet)Mockito.mock(CircleDimensionSet.class), this.dataIOSet, executionSet);
        Node<View<BaseThrowingIntermediateEvent>, Edge> dockNode = IntermediateThrowEventConverterTest.mockNode();
        Node<View<BaseThrowingIntermediateEvent>, Edge> node = IntermediateThrowEventConverterTest.mockDockedNode(dockNode, (BaseThrowingIntermediateEvent)eventThrowing);
        return node;
    }

    private Node createIntermediateLinkEventThrowingNode() {
        LinkEventExecutionSet executionSet = new LinkEventExecutionSet(this.linkRef);
        IntermediateLinkEventThrowing eventThrowing = new IntermediateLinkEventThrowing(this.generalSet, (BackgroundSet)Mockito.mock(BackgroundSet.class), (FontSet)Mockito.mock(FontSet.class), (CircleDimensionSet)Mockito.mock(CircleDimensionSet.class), this.dataIOSet, executionSet);
        Node<View<BaseThrowingIntermediateEvent>, Edge> dockNode = IntermediateThrowEventConverterTest.mockNode();
        Node<View<BaseThrowingIntermediateEvent>, Edge> node = IntermediateThrowEventConverterTest.mockDockedNode(dockNode, (BaseThrowingIntermediateEvent)eventThrowing);
        return node;
    }

    private Node createIntermediateMessageEventThrowingNode() {
        MessageEventExecutionSet executionSet = new MessageEventExecutionSet(this.messageRef);
        IntermediateMessageEventThrowing eventThrowing = new IntermediateMessageEventThrowing(this.generalSet, (BackgroundSet)Mockito.mock(BackgroundSet.class), (FontSet)Mockito.mock(FontSet.class), (CircleDimensionSet)Mockito.mock(CircleDimensionSet.class), this.dataIOSet, executionSet);
        Node<View<BaseThrowingIntermediateEvent>, Edge> dockNode = IntermediateThrowEventConverterTest.mockNode();
        Node<View<BaseThrowingIntermediateEvent>, Edge> node = IntermediateThrowEventConverterTest.mockDockedNode(dockNode, (BaseThrowingIntermediateEvent)eventThrowing);
        return node;
    }

    private Node createIntermediateEscalationEventThrowingNode() {
        EscalationEventExecutionSet executionSet = new EscalationEventExecutionSet(this.escalationRef);
        IntermediateEscalationEventThrowing eventThrowing = new IntermediateEscalationEventThrowing(this.generalSet, (BackgroundSet)Mockito.mock(BackgroundSet.class), (FontSet)Mockito.mock(FontSet.class), (CircleDimensionSet)Mockito.mock(CircleDimensionSet.class), this.dataIOSet, executionSet);
        Node<View<BaseThrowingIntermediateEvent>, Edge> dockNode = IntermediateThrowEventConverterTest.mockNode();
        Node<View<BaseThrowingIntermediateEvent>, Edge> node = IntermediateThrowEventConverterTest.mockDockedNode(dockNode, (BaseThrowingIntermediateEvent)eventThrowing);
        return node;
    }

    private Node createIntermediateCompensationEventThrowingNode() {
        CompensationEventExecutionSet executionSet = new CompensationEventExecutionSet();
        IntermediateCompensationEventThrowing eventThrowing = new IntermediateCompensationEventThrowing(this.generalSet, (BackgroundSet)Mockito.mock(BackgroundSet.class), (FontSet)Mockito.mock(FontSet.class), (CircleDimensionSet)Mockito.mock(CircleDimensionSet.class), this.dataIOSet, executionSet);
        Node<View<BaseThrowingIntermediateEvent>, Edge> dockNode = IntermediateThrowEventConverterTest.mockNode();
        Node<View<BaseThrowingIntermediateEvent>, Edge> node = IntermediateThrowEventConverterTest.mockDockedNode(dockNode, (BaseThrowingIntermediateEvent)eventThrowing);
        return node;
    }

    private static Node<View<BaseThrowingIntermediateEvent>, Edge> mockNode() {
        Node node = (Node)Mockito.mock(Node.class);
        View view = (View)Mockito.mock(View.class);
        Bound ul = new Bound(Double.valueOf(0.0), Double.valueOf(100.0));
        Bound lr = new Bound(Double.valueOf(200.0), Double.valueOf(0.0));
        Bounds bounds = new Bounds(ul, lr);
        Mockito.when((Object)node.getContent()).thenReturn((Object)view);
        Mockito.when((Object)view.getBounds()).thenReturn((Object)bounds);
        return node;
    }

    private static Node<View<BaseThrowingIntermediateEvent>, Edge> mockDockedNode(Node dockSourceNode, BaseThrowingIntermediateEvent event) {
        Dock dockContent = (Dock)Mockito.mock(Dock.class);
        Edge edge = (Edge)Mockito.mock(Edge.class);
        List<Edge> inEdges = Collections.singletonList(edge);
        Node node = (Node)Mockito.mock(Node.class);
        View view = (View)Mockito.mock(View.class);
        Bound ul = new Bound(Double.valueOf(0.0), Double.valueOf(100.0));
        Bound lr = new Bound(Double.valueOf(200.0), Double.valueOf(0.0));
        Bounds bounds = new Bounds(ul, lr);
        Mockito.when((Object)node.getUUID()).thenReturn((Object)UUID);
        Mockito.when((Object)node.getInEdges()).thenReturn(inEdges);
        Mockito.when((Object)node.getContent()).thenReturn((Object)view);
        Mockito.when((Object)edge.getContent()).thenReturn((Object)dockContent);
        Mockito.when((Object)edge.getSourceNode()).thenReturn((Object)dockSourceNode);
        Mockito.when((Object)view.getBounds()).thenReturn((Object)bounds);
        Mockito.when((Object)view.getDefinition()).thenReturn((Object)event);
        return node;
    }
}

