/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.events;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.EscalationEventDefinition;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.IntermediateThrowEvent;
import org.eclipse.bpmn2.LinkEventDefinition;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.eclipse.bpmn2.ThrowEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.events.IntermediateThrowEventConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.ThrowEventPropertyReader;
import org.kie.workbench.common.stunner.bpmn.definition.BaseThrowingIntermediateEvent;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateCompensationEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateEscalationEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateLinkEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateMessageEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateSignalEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.property.background.BackgroundSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.CircleDimensionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.compensation.CompensationEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.escalation.EscalationEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.link.LinkEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.MessageEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.ScopedSignalEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.font.FontSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingRequest;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class IntermediateThrowEventConverterTest {
    private static final String UUID = "THROW EVENT UUID";
    private TypedFactoryManager factoryManager;
    private PropertyReaderFactory propertyReaderFactory;
    private ThrowEventPropertyReader propertyReader;
    private View view;
    private List<EventDefinition> eventDefinitions;
    private IntermediateThrowEventConverter tested;

    @Before
    public void setUp() {
        this.factoryManager = (TypedFactoryManager)Mockito.mock(TypedFactoryManager.class);
        this.propertyReaderFactory = (PropertyReaderFactory)Mockito.mock(PropertyReaderFactory.class);
        this.propertyReader = (ThrowEventPropertyReader)Mockito.mock(ThrowEventPropertyReader.class);
        this.eventDefinitions = new ArrayList<EventDefinition>();
        Mockito.when((Object)this.propertyReader.getEventDefinitions()).thenReturn(this.eventDefinitions);
        Mockito.when((Object)this.propertyReaderFactory.of((ThrowEvent)Matchers.any(ThrowEvent.class))).thenReturn((Object)this.propertyReader);
        this.view = (View)Mockito.mock(View.class);
        this.tested = (IntermediateThrowEventConverter)Mockito.spy((Object)new IntermediateThrowEventConverter(this.factoryManager, this.propertyReaderFactory, MarshallingRequest.Mode.IGNORE));
    }

    @Test
    public void convert() {
        this.eventDefinitions.clear();
        try {
            this.tested.convert((IntermediateThrowEvent)Matchers.any(IntermediateThrowEvent.class));
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            Assert.assertTrue((boolean)(exception instanceof UnsupportedOperationException));
            Assert.assertEquals((Object)"An intermediate throw event should contain exactly one definition", (Object)exception.getMessage());
        }
        this.verifyMessageEventConvert();
        this.verifySignalEventConvert();
        this.verifyLinkEventConvert();
        this.verifyEscalationEventConvert();
        this.verifyCompensationEventConvert();
        this.eventDefinitions.clear();
        this.eventDefinitions.add((EventDefinition)Mockito.mock(EventDefinition.class));
        this.eventDefinitions.add((EventDefinition)Mockito.mock(EventDefinition.class));
        try {
            this.tested.convert((IntermediateThrowEvent)Matchers.any(IntermediateThrowEvent.class));
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            Assert.assertTrue((boolean)(exception instanceof UnsupportedOperationException));
            Assert.assertEquals((Object)"Multiple definitions not supported for intermediate throw event", (Object)exception.getMessage());
        }
        ((ThrowEventPropertyReader)Mockito.verify((Object)this.propertyReader, (VerificationMode)Mockito.times((int)7))).getEventDefinitions();
    }

    @Test
    public void constructor() {
        Assert.assertEquals((Object)this.factoryManager, (Object)this.tested.factoryManager);
        Assert.assertEquals((Object)this.propertyReaderFactory, (Object)this.tested.propertyReaderFactory);
    }

    @Test
    public void messageEvent() {
        IntermediateMessageEventThrowing definition = (IntermediateMessageEventThrowing)Mockito.mock(IntermediateMessageEventThrowing.class);
        MessageEventDefinition eventDefinition = (MessageEventDefinition)Mockito.mock(MessageEventDefinition.class);
        IntermediateThrowEvent intermediateThrowEvent = this.mockIntermediateThrowEvent((BaseThrowingIntermediateEvent)definition);
        this.tested.messageEvent(intermediateThrowEvent, eventDefinition);
        this.verifyCommonProperties((BaseThrowingIntermediateEvent)definition);
        ((MessageEventDefinition)Mockito.verify((Object)eventDefinition, (VerificationMode)Mockito.times((int)2))).getMessageRef();
        ((IntermediateMessageEventThrowing)Mockito.verify((Object)definition)).setExecutionSet((MessageEventExecutionSet)Matchers.any(MessageEventExecutionSet.class));
    }

    @Test
    public void signalEvent() {
        IntermediateSignalEventThrowing definition = (IntermediateSignalEventThrowing)Mockito.mock(IntermediateSignalEventThrowing.class);
        IntermediateThrowEvent intermediateThrowEvent = this.mockIntermediateThrowEvent((BaseThrowingIntermediateEvent)definition);
        this.tested.signalEvent(intermediateThrowEvent);
        this.verifyCommonProperties((BaseThrowingIntermediateEvent)definition);
        ((ThrowEventPropertyReader)Mockito.verify((Object)this.propertyReader)).getSignalRef();
        ((ThrowEventPropertyReader)Mockito.verify((Object)this.propertyReader)).getSignalScope();
        ((IntermediateSignalEventThrowing)Mockito.verify((Object)definition)).setExecutionSet((ScopedSignalEventExecutionSet)Matchers.any(ScopedSignalEventExecutionSet.class));
    }

    @Test
    public void linkEvent() {
        IntermediateLinkEventThrowing definition = (IntermediateLinkEventThrowing)Mockito.mock(IntermediateLinkEventThrowing.class);
        IntermediateThrowEvent intermediateThrowEvent = this.mockIntermediateThrowEvent((BaseThrowingIntermediateEvent)definition);
        this.tested.linkEvent(intermediateThrowEvent);
        this.verifyCommonProperties((BaseThrowingIntermediateEvent)definition);
        ((ThrowEventPropertyReader)Mockito.verify((Object)this.propertyReader)).getLinkRef();
        ((IntermediateLinkEventThrowing)Mockito.verify((Object)definition)).setExecutionSet((LinkEventExecutionSet)Matchers.any(LinkEventExecutionSet.class));
    }

    @Test
    public void escalationEvent() {
        IntermediateEscalationEventThrowing definition = (IntermediateEscalationEventThrowing)Mockito.mock(IntermediateEscalationEventThrowing.class);
        EscalationEventDefinition eventDefinition = (EscalationEventDefinition)Mockito.mock(EscalationEventDefinition.class);
        IntermediateThrowEvent intermediateThrowEvent = this.mockIntermediateThrowEvent((BaseThrowingIntermediateEvent)definition);
        this.tested.escalationEvent(intermediateThrowEvent, eventDefinition);
        this.verifyCommonProperties((BaseThrowingIntermediateEvent)definition);
        ((EscalationEventDefinition)Mockito.verify((Object)eventDefinition)).getEscalationRef();
        ((IntermediateEscalationEventThrowing)Mockito.verify((Object)definition)).setExecutionSet((EscalationEventExecutionSet)Matchers.any(EscalationEventExecutionSet.class));
    }

    @Test
    public void compensationEvent() {
        IntermediateCompensationEventThrowing definition = (IntermediateCompensationEventThrowing)Mockito.mock(IntermediateCompensationEventThrowing.class);
        CompensateEventDefinition eventDefinition = (CompensateEventDefinition)Mockito.mock(CompensateEventDefinition.class);
        IntermediateThrowEvent intermediateThrowEvent = this.mockIntermediateThrowEvent((BaseThrowingIntermediateEvent)definition);
        this.tested.compensationEvent(intermediateThrowEvent, eventDefinition);
        this.verifyCommonProperties((BaseThrowingIntermediateEvent)definition);
        ((IntermediateCompensationEventThrowing)Mockito.verify((Object)definition)).setExecutionSet((CompensationEventExecutionSet)Matchers.any(CompensationEventExecutionSet.class));
    }

    private void verifyCommonProperties(BaseThrowingIntermediateEvent definition) {
        ((ThrowEventPropertyReader)Mockito.verify((Object)this.propertyReader)).getBounds();
        ((View)Mockito.verify((Object)this.view)).setBounds((Bounds)Matchers.any(Bounds.class));
        ((ThrowEventPropertyReader)Mockito.verify((Object)this.propertyReader)).getName();
        ((ThrowEventPropertyReader)Mockito.verify((Object)this.propertyReader)).getDocumentation();
        ((BaseThrowingIntermediateEvent)Mockito.verify((Object)definition)).setGeneral((BPMNGeneralSet)Matchers.any(BPMNGeneralSet.class));
        ((ThrowEventPropertyReader)Mockito.verify((Object)this.propertyReader)).getBackgroundSet();
        ((BaseThrowingIntermediateEvent)Mockito.verify((Object)definition)).setBackgroundSet((BackgroundSet)Matchers.any(BackgroundSet.class));
        ((ThrowEventPropertyReader)Mockito.verify((Object)this.propertyReader)).getFontSet();
        ((BaseThrowingIntermediateEvent)Mockito.verify((Object)definition)).setFontSet((FontSet)Matchers.any(FontSet.class));
        ((ThrowEventPropertyReader)Mockito.verify((Object)this.propertyReader)).getCircleDimensionSet();
        ((BaseThrowingIntermediateEvent)Mockito.verify((Object)definition)).setDimensionsSet((CircleDimensionSet)Matchers.any(CircleDimensionSet.class));
        ((ThrowEventPropertyReader)Mockito.verify((Object)this.propertyReader)).getAssignmentsInfo();
        ((BaseThrowingIntermediateEvent)Mockito.verify((Object)definition)).setDataIOSet((DataIOSet)Matchers.any(DataIOSet.class));
    }

    private void verifyMessageEventConvert() {
        IntermediateMessageEventThrowing definition = (IntermediateMessageEventThrowing)Mockito.mock(IntermediateMessageEventThrowing.class);
        MessageEventDefinition eventDefinition = (MessageEventDefinition)Mockito.mock(MessageEventDefinition.class);
        IntermediateThrowEvent intermediateThrowEvent = this.mockIntermediateThrowEvent((BaseThrowingIntermediateEvent)definition);
        this.eventDefinitions.clear();
        this.eventDefinitions.add((EventDefinition)eventDefinition);
        this.tested.convert(intermediateThrowEvent);
        ((IntermediateThrowEventConverter)Mockito.verify((Object)this.tested)).messageEvent(intermediateThrowEvent, eventDefinition);
    }

    private void verifySignalEventConvert() {
        IntermediateSignalEventThrowing definition = (IntermediateSignalEventThrowing)Mockito.mock(IntermediateSignalEventThrowing.class);
        SignalEventDefinition eventDefinition = (SignalEventDefinition)Mockito.mock(SignalEventDefinition.class);
        IntermediateThrowEvent intermediateThrowEvent = this.mockIntermediateThrowEvent((BaseThrowingIntermediateEvent)definition);
        this.eventDefinitions.clear();
        this.eventDefinitions.add((EventDefinition)eventDefinition);
        this.tested.convert(intermediateThrowEvent);
        ((IntermediateThrowEventConverter)Mockito.verify((Object)this.tested)).signalEvent(intermediateThrowEvent);
    }

    private void verifyLinkEventConvert() {
        IntermediateLinkEventThrowing definition = (IntermediateLinkEventThrowing)Mockito.mock(IntermediateLinkEventThrowing.class);
        LinkEventDefinition eventDefinition = (LinkEventDefinition)Mockito.mock(LinkEventDefinition.class);
        IntermediateThrowEvent intermediateThrowEvent = this.mockIntermediateThrowEvent((BaseThrowingIntermediateEvent)definition);
        this.eventDefinitions.clear();
        this.eventDefinitions.add((EventDefinition)eventDefinition);
        this.tested.convert(intermediateThrowEvent);
        ((IntermediateThrowEventConverter)Mockito.verify((Object)this.tested)).linkEvent(intermediateThrowEvent);
    }

    private void verifyEscalationEventConvert() {
        IntermediateEscalationEventThrowing definition = (IntermediateEscalationEventThrowing)Mockito.mock(IntermediateEscalationEventThrowing.class);
        EscalationEventDefinition eventDefinition = (EscalationEventDefinition)Mockito.mock(EscalationEventDefinition.class);
        IntermediateThrowEvent intermediateThrowEvent = this.mockIntermediateThrowEvent((BaseThrowingIntermediateEvent)definition);
        this.eventDefinitions.clear();
        this.eventDefinitions.add((EventDefinition)eventDefinition);
        this.tested.convert(intermediateThrowEvent);
        ((IntermediateThrowEventConverter)Mockito.verify((Object)this.tested)).escalationEvent(intermediateThrowEvent, eventDefinition);
    }

    private void verifyCompensationEventConvert() {
        IntermediateCompensationEventThrowing definition = (IntermediateCompensationEventThrowing)Mockito.mock(IntermediateCompensationEventThrowing.class);
        CompensateEventDefinition eventDefinition = (CompensateEventDefinition)Mockito.mock(CompensateEventDefinition.class);
        IntermediateThrowEvent intermediateThrowEvent = this.mockIntermediateThrowEvent((BaseThrowingIntermediateEvent)definition);
        this.eventDefinitions.clear();
        this.eventDefinitions.add((EventDefinition)eventDefinition);
        this.tested.convert(intermediateThrowEvent);
        ((IntermediateThrowEventConverter)Mockito.verify((Object)this.tested)).compensationEvent(intermediateThrowEvent, eventDefinition);
    }

    private IntermediateThrowEvent mockIntermediateThrowEvent(BaseThrowingIntermediateEvent eventDefinition) {
        IntermediateThrowEvent intermediateThrowEvent = (IntermediateThrowEvent)Mockito.mock(IntermediateThrowEvent.class);
        Mockito.when((Object)intermediateThrowEvent.getId()).thenReturn((Object)UUID);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.factoryManager.newNode((String)Matchers.eq((Object)UUID), (Class)Matchers.any())).thenReturn((Object)node);
        Mockito.when((Object)node.getContent()).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.getDefinition()).thenReturn((Object)eventDefinition);
        return intermediateThrowEvent;
    }
}

