/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.model;

import java.util.Arrays;
import javax.validation.Valid;
import org.kie.workbench.common.dmn.api.definition.model.NamedElement;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinksFieldType;
import org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinksHolder;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.rules.NoInputNodesInImportedDecisionRule;
import org.kie.workbench.common.forms.adf.definitions.DynamicReadOnly;
import org.kie.workbench.common.forms.adf.definitions.annotations.FormField;
import org.kie.workbench.common.stunner.core.definition.annotation.Property;
import org.kie.workbench.common.stunner.core.graph.content.HasContentDefinitionId;
import org.kie.workbench.common.stunner.core.graph.content.HasStringName;
import org.kie.workbench.common.stunner.core.rule.annotation.RuleExtension;

@RuleExtension(handler=NoInputNodesInImportedDecisionRule.class)
public abstract class DRGElement
extends NamedElement
implements DynamicReadOnly,
HasContentDefinitionId,
HasStringName {
    private static final String[] READONLY_FIELDS = new String[]{"NameHolder", "AllowedAnswers", "Description", "Question", "DataType", "SourceType", "LocationURI"};
    protected boolean allowOnlyVisualChange;
    private String dmnDiagramId;
    @Property
    @FormField(afterElement="description", type=DocumentationLinksFieldType.class)
    @Valid
    protected DocumentationLinksHolder linksHolder = new DocumentationLinksHolder();

    public DRGElement() {
    }

    public DRGElement(Id id, Description description, Name name) {
        super(id, description, name);
    }

    public void setAllowOnlyVisualChange(boolean allowOnlyVisualChange) {
        this.allowOnlyVisualChange = allowOnlyVisualChange;
    }

    public boolean isAllowOnlyVisualChange() {
        return this.allowOnlyVisualChange;
    }

    public DynamicReadOnly.ReadOnly getReadOnly(String fieldName) {
        if (!this.isAllowOnlyVisualChange()) {
            return DynamicReadOnly.ReadOnly.NOT_SET;
        }
        if (this.isReadonlyField(fieldName)) {
            return DynamicReadOnly.ReadOnly.TRUE;
        }
        return DynamicReadOnly.ReadOnly.FALSE;
    }

    public String getContentDefinitionId() {
        return this.getId().getValue();
    }

    public String getDiagramId() {
        return this.dmnDiagramId;
    }

    public void setDiagramId(String dmnDiagramId) {
        this.dmnDiagramId = dmnDiagramId;
    }

    public void setContentDefinitionId(String contentDefinitionId) {
        this.setId(new Id(contentDefinitionId));
    }

    protected boolean isReadonlyField(String fieldName) {
        return Arrays.stream(READONLY_FIELDS).anyMatch(f -> f.equalsIgnoreCase(fieldName));
    }

    public DocumentationLinksHolder getLinksHolder() {
        return this.linksHolder;
    }

    public void setLinksHolder(DocumentationLinksHolder linksHolder) {
        this.linksHolder = linksHolder;
    }

    public String getStringName() {
        return this.getName().getValue();
    }
}

