/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server.indexing;

import java.io.InputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.compiler.compiler.DecisionTableFactory;
import org.drools.workbench.screens.dtablexls.type.DecisionTableXLSXResourceTypeDefinition;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.soup.project.datamodel.oracle.ModuleDataModelOracle;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.IndexBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.drools.AbstractDrlFileIndexer;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardOpenOption;

@ApplicationScoped
public class DecisionTableXLSXFileIndexer
extends AbstractDrlFileIndexer {
    @Inject
    private DataModelService dataModelService;
    @Inject
    protected DecisionTableXLSXResourceTypeDefinition type;

    public boolean supportsPath(Path path) {
        return this.type.accept(Paths.convert((Path)path));
    }

    public IndexBuilder fillIndexBuilder(Path path) throws Exception {
        try (InputStream inputStream = this.ioService.newInputStream(path, new OpenOption[]{StandardOpenOption.READ});){
            DecisionTableConfiguration configuration = KnowledgeBuilderFactory.newDecisionTableConfiguration();
            configuration.setInputType(DecisionTableInputType.XLSX);
            String drl = DecisionTableFactory.loadFromInputStream((InputStream)inputStream, (DecisionTableConfiguration)configuration);
            IndexBuilder indexBuilder = this.fillDrlIndexBuilder(path, drl);
            return indexBuilder;
        }
    }

    protected ModuleDataModelOracle getModuleDataModelOracle(Path path) {
        return this.dataModelService.getModuleDataModel(Paths.convert((Path)path));
    }
}

