/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.dropbox;

import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.WriteMode;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.jbpm.document.Document;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.dropbox.DropboxAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="DropboxUploadFileDefinitions.wid", name="DropboxUploadFile", displayName="DropboxUploadFile", defaultHandler="mvel: new org.jbpm.process.workitem.dropbox.UploadFileWorkitemHandler(\"clientIdentifier\", \"accessToken\")", documentation="dropbox-workitem/index.html", category="dropbox-workitem", icon="DropboxUploadFile.png", parameters={@WidParameter(name="Path", required=true), @WidParameter(name="Document", required=true, runtimeType="org.jbpm.document.Document")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="dropbox-workitem", version="7.48.0.Final")}, serviceInfo=@WidService(category="Dropbox", description="Upload and download files from Dropbox", keywords="DropBox,file,files,upload,document,documents", action=@WidAction(title="Download a file from DropBox"), authinfo=@WidAuth(required=true, params={"clientIdentifier", "accessToken"}, paramsdescription={"Dropbox client identifier", "Dropbox access token"}, referencesite="https://www.dropbox.com/lp/developers")))
public class UploadFileWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(UploadFileWorkitemHandler.class);
    private DropboxAuth auth;
    private DbxClientV2 client;
    private String clientIdentifier;
    private String accessToken;

    public UploadFileWorkitemHandler(String clientIdentifier, String accessToken) {
        this.clientIdentifier = clientIdentifier;
        this.accessToken = accessToken;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            if (this.auth == null) {
                this.auth = new DropboxAuth();
            }
            this.client = this.auth.authorize(this.clientIdentifier, this.accessToken);
            String dropboxPath = (String)workItem.getParameter("Path");
            Document documentToUpload = (Document)workItem.getParameter("Document");
            ByteArrayInputStream docStream = new ByteArrayInputStream(documentToUpload.getContent());
            this.client.files().uploadBuilder(dropboxPath + "/" + documentToUpload.getName()).withMode(WriteMode.ADD).withClientModified(documentToUpload.getLastModified()).uploadAndFinish((InputStream)docStream);
            workItemManager.completeWorkItem(workItem.getId(), null);
        }
        catch (Exception e) {
            logger.error("Unable to upload file: " + e.getMessage());
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(DropboxAuth auth) {
        this.auth = auth;
    }
}

