/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler.ast;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Optional;
import org.drools.mvelcompiler.ast.TypedExpression;

public class BigDecimalArithmeticExprT
implements TypedExpression {
    private final String name;
    private final TypedExpression argument;
    private final TypedExpression scope;
    private final Type type = BigDecimal.class;

    public static String toBigDecimalMethod(BinaryExpr.Operator operator) {
        switch (operator) {
            case PLUS: {
                return "add";
            }
            case MINUS: {
                return "subtract";
            }
            case MULTIPLY: {
                return "multiply";
            }
            case DIVIDE: {
                return "divide";
            }
        }
        throw new RuntimeException("Unknown operator");
    }

    public static String toBigDecimalMethod(AssignExpr.Operator operator) {
        switch (operator) {
            case PLUS: {
                return "add";
            }
            case MINUS: {
                return "subtract";
            }
            case MULTIPLY: {
                return "multiply";
            }
            case DIVIDE: {
                return "divide";
            }
            case ASSIGN: {
                return "valueOf";
            }
        }
        throw new RuntimeException("Unknown operator");
    }

    public BigDecimalArithmeticExprT(String bigDecimalMethod, TypedExpression scope, TypedExpression argument) {
        this.name = bigDecimalMethod;
        this.scope = scope;
        this.argument = argument;
    }

    @Override
    public Optional<Type> getType() {
        return Optional.of(this.type);
    }

    @Override
    public Node toJavaExpression() {
        return new MethodCallExpr((Expression)this.scope.toJavaExpression(), this.name, NodeList.nodeList((Node[])new Expression[]{(Expression)this.argument.toJavaExpression()}));
    }

    public String toString() {
        return "BigDecimalExprT{name='" + this.name + '\'' + ", argument=" + this.argument + ", type=" + this.type + '}';
    }
}

