/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.github;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.egit.github.core.Gist;
import org.eclipse.egit.github.core.GistFile;
import org.eclipse.egit.github.core.service.GistService;
import org.jbpm.document.Document;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.github.GithubAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="GithubCreateGist.wid", name="GithubCreateGist", displayName="GithubCreateGist", defaultHandler="mvel: new org.jbpm.process.workitem.github.CreateGistWorkitemHandler(\"userName\", \"password\")", documentation="github-workitem/index.html", category="github-workitem", icon="GithubCreateGist.png", parameters={@WidParameter(name="Content", required=true, runtimeType="org.jbpm.document.Document"), @WidParameter(name="Description"), @WidParameter(name="IsPublic")}, results={@WidResult(name="GistURL")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="github-workitem", version="7.50.0.Final")}, serviceInfo=@WidService(category="Github", description="Create Gist or list your repositories in Github", keywords="gist,github,create", action=@WidAction(title="Create a new Gist"), authinfo=@WidAuth(required=true, params={"userName", "password"}, paramsdescription={"Github username", "Github password"}, referencesite="https://github.com/")))
public class CreateGistWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String userName;
    private String password;
    private GithubAuth auth = new GithubAuth();
    private static final Logger logger = LoggerFactory.getLogger(CreateGistWorkitemHandler.class);
    private static final String RESULTS_VALUE = "GistURL";

    public CreateGistWorkitemHandler(String userName, String password) {
        this.userName = userName;
        this.password = password;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            Document content = (Document)workItem.getParameter("Content");
            String description = (String)workItem.getParameter("Description");
            String isPublicStr = (String)workItem.getParameter("IsPublic");
            HashMap<String, String> results = new HashMap<String, String>();
            GistService gistService = this.auth.getGistService(this.userName, this.password);
            Gist gist = new Gist();
            gist.setPublic(Boolean.parseBoolean(isPublicStr));
            gist.setDescription(description);
            GistFile file = new GistFile();
            file.setContent(new String(content.getContent(), StandardCharsets.UTF_8));
            file.setFilename(content.getName());
            gist.setFiles(Collections.singletonMap(file.getFilename(), file));
            gist = gistService.createGist(gist);
            results.put(RESULTS_VALUE, gist.getHtmlUrl());
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(GithubAuth auth) {
        this.auth = auth;
    }
}

