/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import org.eclipse.bpmn2.Error;
import org.eclipse.bpmn2.ErrorEventDefinition;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.RootElement;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.EventPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.error.ErrorRef;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class EventPropertyWriterTest {
    protected Event event;
    protected static final String ERROR_CODE = "ERROR_CODE";
    protected static final String elementId = "MY_ID";
    protected EventPropertyWriter propertyWriter;

    @Test
    public void testAddEmptyError() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(RootElement.class);
        ErrorRef errorRef = new ErrorRef();
        this.propertyWriter.addError(errorRef);
        ErrorEventDefinition definition = this.getErrorDefinition();
        Assert.assertNull((Object)definition.getErrorRef().getErrorCode());
        Assert.assertFalse((boolean)definition.getErrorRef().getId().isEmpty());
        ((EventPropertyWriter)Mockito.verify((Object)this.propertyWriter)).addRootElement((RootElement)captor.capture());
        Error error = (Error)captor.getValue();
        Assert.assertNull((Object)error.getErrorCode());
        Assert.assertFalse((boolean)error.getId().isEmpty());
    }

    public abstract ErrorEventDefinition getErrorDefinition();

    @Test
    public void testAddError() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(RootElement.class);
        ErrorRef errorRef = new ErrorRef();
        errorRef.setValue(ERROR_CODE);
        this.propertyWriter.addError(errorRef);
        ErrorEventDefinition definition = this.getErrorDefinition();
        Assert.assertEquals((Object)ERROR_CODE, (Object)definition.getErrorRef().getErrorCode());
        Assert.assertFalse((boolean)definition.getErrorRef().getId().isEmpty());
        ((EventPropertyWriter)Mockito.verify((Object)this.propertyWriter)).addRootElement((RootElement)captor.capture());
        Error error = (Error)captor.getValue();
        Assert.assertEquals((Object)ERROR_CODE, (Object)error.getErrorCode());
        Assert.assertFalse((boolean)error.getId().isEmpty());
    }
}

