/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties;

import java.util.Locale;
import java.util.Optional;
import org.eclipse.bpmn2.BaseElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.AttributeDefinition;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.BooleanAttribute;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.StringAttribute;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;

public class CustomAttribute<T> {
    private static final String droolsns = "http://www.jboss.org/drools";
    public static final AttributeDefinition<Boolean> independent = new BooleanAttribute("http://www.jboss.org/drools", "independent", false);
    public static final AttributeDefinition<Boolean> adHoc = new BooleanAttribute("http://www.jboss.org/drools", "adHoc", false);
    public static final AttributeDefinition<Boolean> waitForCompletion = new BooleanAttribute("http://www.jboss.org/drools", "waitForCompletion", false);
    public static final AttributeDefinition<String> serviceTaskName = new StringAttribute("http://www.jboss.org/drools", "taskName", "");
    public static final AttributeDefinition<String> ruleFlowGroup = new StringAttribute("http://www.jboss.org/drools", "ruleFlowGroup", "");
    public static final AttributeDefinition<String> packageName = new StringAttribute("http://www.jboss.org/drools", "packageName", null){

        @Override
        public void setValue(BaseElement element, String value) {
            if (value != null) {
                super.setValue(element, value.isEmpty() ? "org.jbpm" : value);
            }
        }
    };
    public static final AttributeDefinition<String> version = new StringAttribute("http://www.jboss.org/drools", "version", "1.0");
    public static final AttributeDefinition<String> errorName = new StringAttribute("http://www.jboss.org/drools", "erefname", "");
    public static final AttributeDefinition<String> msgref = new StringAttribute("http://www.jboss.org/drools", "msgref", "");
    public static final AttributeDefinition<String> esccode = new StringAttribute("http://www.jboss.org/drools", "esccode", "");
    public static final AttributeDefinition<Boolean> boundarycaForBoundaryEvent = new BooleanAttribute("http://www.jboss.org/drools", "boundaryca", false){

        @Override
        public Boolean getValue(BaseElement element) {
            String value = super.getStringValue(element).orElse("");
            return value.isEmpty() ? (Boolean)this.defaultValue : Boolean.parseBoolean(value);
        }
    };
    public static final AttributeDefinition<Boolean> boundarycaForEvent = new BooleanAttribute("http://www.jboss.org/drools", "boundaryca", true){

        @Override
        public Boolean getValue(BaseElement element) {
            String value = super.getStringValue(element).orElse("");
            return value.isEmpty() ? (Boolean)this.defaultValue : Boolean.parseBoolean(value);
        }
    };
    public static final AttributeDefinition<String> priority = new StringAttribute("http://www.jboss.org/drools", "priority", null);
    public static final AttributeDefinition<String> dtype = new StringAttribute("http://www.jboss.org/drools", "dtype", "");
    public static final AttributeDefinition<String> dg = new StringAttribute("http://www.jboss.org/drools", "dg", ""){

        @Override
        public String getValue(BaseElement element) {
            String value = super.getValue(element);
            return value.isEmpty() ? null : value;
        }
    };
    public static final AttributeDefinition<Point2D> dockerInfo = new AttributeDefinition<Point2D>("http://www.jboss.org/drools", "dockerinfo", Point2D.create((double)0.0, (double)0.0)){

        @Override
        public Point2D getValue(BaseElement element) {
            Optional<String> attribute = this.getStringValue(element);
            if (attribute.isPresent()) {
                String dockerInfoStr = attribute.get();
                dockerInfoStr = dockerInfoStr.substring(0, dockerInfoStr.length() - 1);
                String[] dockerInfoParts = dockerInfoStr.split("\\|");
                String infoPartsToUse = dockerInfoParts[0];
                String[] infoPartsToUseParts = infoPartsToUse.split("\\^");
                double x = Double.valueOf(infoPartsToUseParts[0]);
                double y = Double.valueOf(infoPartsToUseParts[1]);
                return Point2D.create((double)x, (double)y);
            }
            return Point2D.create((double)0.0, (double)0.0);
        }

        @Override
        public void setValue(BaseElement element, Point2D value) {
            this.setStringValue(element, String.format(Locale.ENGLISH, "%.1f^%.1f|", value.getX(), value.getY()));
        }
    };
    public static final AttributeDefinition<String> serviceOperation = new StringAttribute("http://www.jboss.org/drools", "serviceoperation", "");
    public static final AttributeDefinition<String> serviceImplementation = new StringAttribute("http://www.jboss.org/drools", "serviceimplementation", "");
    public static final AttributeDefinition<String> serviceInterface = new StringAttribute("http://www.jboss.org/drools", "serviceinterface", "");
    private final AttributeDefinition<T> attributeDefinition;
    private final BaseElement element;

    public CustomAttribute(AttributeDefinition<T> attributeDefinition, BaseElement element) {
        this.attributeDefinition = attributeDefinition;
        this.element = element;
    }

    public T get() {
        return this.attributeDefinition.getValue(this.element);
    }

    public void set(T value) {
        if (value != null) {
            this.attributeDefinition.setValue(this.element, value);
        }
    }
}

