/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.workitem;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.guvnor.common.services.project.model.Dependencies;
import org.guvnor.common.services.project.model.Dependency;
import org.jbpm.process.core.ParameterDefinition;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.EnumDataType;
import org.jbpm.process.core.impl.ParameterDefinitionImpl;
import org.jbpm.process.workitem.WorkDefinitionImpl;
import org.jbpm.util.WidMVELEvaluator;
import org.kie.soup.commons.util.Maps;
import org.kie.workbench.common.stunner.bpmn.workitem.IconDefinition;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinition;
import org.kie.workbench.common.stunner.core.backend.util.URLUtils;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkItemDefinitionParser {
    private static final Logger LOG = LoggerFactory.getLogger((String)WorkItemDefinitionParser.class.getName());
    public static final Map<Class<?>, Function<Object, String>> DATA_TYPE_FORMATTERS = new Maps.Builder().put(String.class, value -> value.toString().trim().length() > 0 ? value.toString() : null).put(EnumDataType.class, Object::toString).build();
    public static final String ENCODING = StandardCharsets.UTF_8.name();
    private static final Pattern UNICODE_WORDS_PATTERN = Pattern.compile("\\p{L}+", 256);

    public static Collection<WorkItemDefinition> parse(String content, Function<WorkDefinitionImpl, String> uriProvider, Function<String, String> dataUriProvider) throws Exception {
        Map<String, WorkDefinitionImpl> definitionMap = WorkItemDefinitionParser.parseJBPMWorkItemDefinitions(content, dataUriProvider);
        return definitionMap.values().stream().map(wid -> WorkItemDefinitionParser.parse(wid, uriProvider, dataUriProvider)).collect(Collectors.toList());
    }

    public static WorkItemDefinition parse(WorkDefinitionImpl workDefinition, Function<WorkDefinitionImpl, String> uriProvider, Function<String, String> dataUriProvider) {
        WorkItemDefinition workItem = new WorkItemDefinition();
        workItem.setUri(uriProvider.apply(workDefinition));
        workItem.setName(workDefinition.getName());
        workItem.setCategory(workDefinition.getCategory());
        workItem.setDocumentation(workDefinition.getDocumentation());
        workItem.setDescription(workDefinition.getDescription());
        workItem.setDefaultHandler(workDefinition.getDefaultHandler());
        workItem.setDisplayName(workDefinition.getDisplayName());
        IconDefinition iconDefinition = new IconDefinition();
        String iconEncoded = workDefinition.getIconEncoded();
        String icon = workDefinition.getIcon();
        String iconData = null;
        if (null != iconEncoded && iconEncoded.trim().length() > 0) {
            iconData = iconEncoded;
        } else if (null != icon && icon.trim().length() > 0) {
            String iconUrl = workDefinition.getPath() + "/" + icon;
            iconData = dataUriProvider.apply(iconUrl);
        }
        iconDefinition.setUri(icon);
        iconDefinition.setIconData(iconData);
        workItem.setIconDefinition(iconDefinition);
        workItem.setParameters(WorkItemDefinitionParser.parseParameters(workDefinition.getParameters()));
        workItem.setResults(WorkItemDefinitionParser.parseParameters(workDefinition.getResults()));
        String[] dependencies = workDefinition.getMavenDependencies();
        List dependencyList = null == dependencies ? Collections.emptyList() : Stream.of(dependencies).map(WorkItemDefinitionParser::parseDependency).filter(Objects::nonNull).collect(Collectors.toList());
        workItem.setDependencies(new Dependencies(dependencyList));
        return workItem;
    }

    private static Dependency parseDependency(String raw) {
        String[] gav = raw.split("\\s*:\\s*");
        Dependency result = null;
        if (gav.length >= 3) {
            result = new Dependency();
            result.setGroupId(gav[0]);
            result.setArtifactId(gav[1]);
            result.setVersion(gav[2]);
        }
        if (gav.length >= 4) {
            result.setScope(gav[3]);
        }
        return result;
    }

    private static String parseParameters(Collection<ParameterDefinition> parameters) {
        return "|" + parameters.stream().map(param -> param.getName() + ":" + param.getType().getStringType()).sorted(String::compareTo).collect(Collectors.joining(",")) + "|";
    }

    private static Map<String, WorkDefinitionImpl> parseJBPMWorkItemDefinitions(String content, Function<String, String> dataUriProvider) {
        List workDefinitionsMaps = (List)WidMVELEvaluator.eval((String)content);
        HashMap<String, WorkDefinitionImpl> result = new HashMap<String, WorkDefinitionImpl>(workDefinitionsMaps.size());
        for (Map workDefinitionMap : workDefinitionsMaps) {
            if (workDefinitionMap == null) continue;
            String origWidName = ((String)workDefinitionMap.get("name")).replaceAll("\\s", "");
            Matcher widNameMatcher = UNICODE_WORDS_PATTERN.matcher(origWidName);
            if (widNameMatcher.matches()) {
                WorkDefinitionImpl workDefinition = WorkItemDefinitionParser.parseMVELWorkItemDefinition(workDefinitionMap, dataUriProvider, widNameMatcher.group());
                result.put(workDefinition.getName(), workDefinition);
                continue;
            }
            LOG.error("The work item has an invalid name [ " + workDefinitionMap.get("name") + "].It must contain words only, skipping it.");
        }
        return result;
    }

    private static WorkDefinitionImpl parseMVELWorkItemDefinition(Map<String, Object> workDefinitionMap, Function<String, String> dataUriProvider, String name) {
        WorkDefinitionImpl workDefinition = new WorkDefinitionImpl();
        workDefinition.setName(name);
        WorkItemDefinitionParser.set(workDefinitionMap, "displayName", arg_0 -> ((WorkDefinitionImpl)workDefinition).setDisplayName(arg_0));
        WorkItemDefinitionParser.set(workDefinitionMap, "category", "CustomTasks", arg_0 -> ((WorkDefinitionImpl)workDefinition).setCategory(arg_0));
        WorkItemDefinitionParser.set(workDefinitionMap, "icon", arg_0 -> ((WorkDefinitionImpl)workDefinition).setIcon(arg_0));
        String icon = workDefinition.getIcon();
        if (StringUtils.nonEmpty((String)icon)) {
            String iconData = dataUriProvider.apply(icon);
            workDefinition.setIcon(icon);
            workDefinition.setIconEncoded(iconData);
        }
        WorkItemDefinitionParser.set(workDefinitionMap, "customEditor", arg_0 -> ((WorkDefinitionImpl)workDefinition).setCustomEditor(arg_0));
        WorkItemDefinitionParser.setParameters(workDefinitionMap, "parameters", arg_0 -> ((WorkDefinitionImpl)workDefinition).setParameters(arg_0));
        WorkItemDefinitionParser.setParameters(workDefinitionMap, "results", arg_0 -> ((WorkDefinitionImpl)workDefinition).setResults(arg_0));
        Map values = (Map)workDefinitionMap.get("parameterValues");
        if (null != values) {
            HashMap parameterValues = new HashMap(values.size());
            values.entrySet().forEach(entry -> {
                Object value = entry.getValue();
                Function<Object, String> dataTypeFormatter = DATA_TYPE_FORMATTERS.get(value.getClass());
                if (null != dataTypeFormatter) {
                    parameterValues.put(entry.getKey(), dataTypeFormatter.apply(value));
                } else {
                    LOG.error("The work item's parameter type [" + value.getClass() + "] is not supported. Skipping this parameter.");
                }
            });
            workDefinition.setParameterValues(parameterValues);
        }
        WorkItemDefinitionParser.set(workDefinitionMap, "defaultHandler", "", arg_0 -> ((WorkDefinitionImpl)workDefinition).setDefaultHandler(arg_0));
        WorkItemDefinitionParser.setArray(workDefinitionMap, "dependencies", arg_0 -> ((WorkDefinitionImpl)workDefinition).setDependencies(arg_0));
        WorkItemDefinitionParser.set(workDefinitionMap, "documentation", "", arg_0 -> ((WorkDefinitionImpl)workDefinition).setDocumentation(arg_0));
        WorkItemDefinitionParser.set(workDefinitionMap, "version", "", arg_0 -> ((WorkDefinitionImpl)workDefinition).setVersion(arg_0));
        WorkItemDefinitionParser.set(workDefinitionMap, "description", "", arg_0 -> ((WorkDefinitionImpl)workDefinition).setDescription(arg_0));
        WorkItemDefinitionParser.setArray(workDefinitionMap, "mavenDependencies", arg_0 -> ((WorkDefinitionImpl)workDefinition).setMavenDependencies(arg_0));
        return workDefinition;
    }

    private static void set(Map<String, Object> map, String key, Consumer<String> consumer) {
        WorkItemDefinitionParser.set(map, key, null, consumer);
    }

    private static void set(Map<String, Object> map, String key, String defaultValue, Consumer<String> consumer) {
        String value = (String)map.get(key);
        if (StringUtils.nonEmpty((String)value)) {
            consumer.accept(value);
        } else if (null != defaultValue) {
            consumer.accept(defaultValue);
        }
    }

    private static void setParameters(Map<String, Object> map, String key, Consumer<Set<ParameterDefinition>> consumer) {
        Map parameterMap = (Map)map.get(key);
        if (null != parameterMap) {
            consumer.accept(parameterMap.entrySet().stream().map(entry -> new ParameterDefinitionImpl((String)entry.getKey(), (DataType)entry.getValue())).collect(Collectors.toSet()));
        }
    }

    private static void setArray(Map<String, Object> map, String key, Consumer<String[]> consumer) {
        List values = (List)map.get(key);
        if (null != values) {
            consumer.accept(values.toArray(new String[0]));
        } else {
            consumer.accept(new String[0]);
        }
    }

    public static String buildDataURIFromURL(String url) {
        try {
            return URLUtils.buildDataURIFromURL((String)url);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

