/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.services.rest.factories;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.guvnor.ala.config.RuntimeConfig;
import org.guvnor.ala.runtime.Runtime;
import org.guvnor.ala.runtime.RuntimeBuilder;
import org.guvnor.ala.runtime.RuntimeDestroyer;
import org.guvnor.ala.runtime.RuntimeId;

public class RuntimeFactory {
    private final Collection<RuntimeBuilder> builders = new ArrayList<RuntimeBuilder>();
    private final Collection<RuntimeDestroyer> destroyers = new ArrayList<RuntimeDestroyer>();

    public RuntimeFactory() {
    }

    @Inject
    public RuntimeFactory(Instance<RuntimeBuilder<?, ?>> builders, Instance<RuntimeDestroyer> destroyers) {
        builders.forEach(this.builders::add);
        destroyers.forEach(this.destroyers::add);
    }

    public Optional<Runtime> newRuntime(RuntimeConfig config) {
        return this.builders.stream().filter(rb -> rb.supports(config)).findFirst().flatMap(rb -> (Optional)rb.apply((Object)config));
    }

    public void destroyRuntime(RuntimeId runtimeId) {
        this.destroyers.stream().filter(rd -> rd.supports(runtimeId)).findFirst().get().destroy(runtimeId);
    }
}

