/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.openssh;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PrivateKeyEntryDecoder;
import org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.loader.AbstractKeyPairResourceParser;
import org.apache.sshd.common.config.keys.loader.openssh.OpenSSHDSSPrivateKeyEntryDecoder;
import org.apache.sshd.common.config.keys.loader.openssh.OpenSSHECDSAPrivateKeyEntryDecoder;
import org.apache.sshd.common.config.keys.loader.openssh.OpenSSHParserContext;
import org.apache.sshd.common.config.keys.loader.openssh.OpenSSHRSAPrivateKeyDecoder;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public class OpenSSHKeyPairResourceParser
extends AbstractKeyPairResourceParser {
    public static final String BEGIN_MARKER = "BEGIN OPENSSH PRIVATE KEY";
    public static final List<String> BEGINNERS = Collections.unmodifiableList(Collections.singletonList("BEGIN OPENSSH PRIVATE KEY"));
    public static final String END_MARKER = "END OPENSSH PRIVATE KEY";
    public static final List<String> ENDERS = Collections.unmodifiableList(Collections.singletonList("END OPENSSH PRIVATE KEY"));
    public static final String AUTH_MAGIC = "openssh-key-v1";
    public static final OpenSSHKeyPairResourceParser INSTANCE = new OpenSSHKeyPairResourceParser();
    private static final byte[] AUTH_MAGIC_BYTES = "openssh-key-v1".getBytes(StandardCharsets.UTF_8);
    private static final Map<String, PrivateKeyEntryDecoder<?, ?>> BY_KEY_TYPE_DECODERS_MAP = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private static final Map<Class<?>, PrivateKeyEntryDecoder<?, ?>> BY_KEY_CLASS_DECODERS_MAP = new HashMap();

    public OpenSSHKeyPairResourceParser() {
        super(BEGINNERS, ENDERS);
    }

    @Override
    public Collection<KeyPair> extractKeyPairs(String resourceKey, String beginMarker, String endMarker, FilePasswordProvider passwordProvider, InputStream stream) throws IOException, GeneralSecurityException {
        int numKeys;
        String kdfName;
        String cipher = KeyEntryResolver.decodeString(stream = this.validateStreamMagicMarker(resourceKey, stream));
        if (!OpenSSHParserContext.IS_NONE_CIPHER.test(cipher)) {
            throw new NoSuchAlgorithmException("Unsupported cipher: " + cipher);
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("extractKeyPairs({}) cipher={}", (Object)resourceKey, (Object)cipher);
        }
        if (!OpenSSHParserContext.IS_NONE_KDF.test(kdfName = KeyEntryResolver.decodeString(stream))) {
            throw new NoSuchAlgorithmException("Unsupported KDF: " + kdfName);
        }
        byte[] kdfOptions = KeyEntryResolver.readRLEBytes(stream);
        if (debugEnabled) {
            this.log.debug("extractKeyPairs({}) KDF={}, options={}", new Object[]{resourceKey, kdfName, BufferUtils.toHex(':', kdfOptions)});
        }
        if ((numKeys = KeyEntryResolver.decodeInt(stream)) <= 0) {
            if (debugEnabled) {
                this.log.debug("extractKeyPairs({}) no encoded keys", (Object)resourceKey);
            }
            return Collections.emptyList();
        }
        ArrayList<PublicKey> publicKeys = new ArrayList<PublicKey>(numKeys);
        OpenSSHParserContext context = new OpenSSHParserContext(cipher, kdfName, kdfOptions);
        boolean traceEnabled = this.log.isTraceEnabled();
        for (int index = 1; index <= numKeys; ++index) {
            PublicKey pubKey = this.readPublicKey(resourceKey, context, stream);
            ValidateUtils.checkNotNull(pubKey, "Empty public key #%d in %s", index, resourceKey);
            if (traceEnabled) {
                this.log.trace("extractKeyPairs({}) read public key #{}: {} {}", new Object[]{resourceKey, index, KeyUtils.getKeyType(pubKey), KeyUtils.getFingerPrint(pubKey)});
            }
            publicKeys.add(pubKey);
        }
        byte[] privateData = KeyEntryResolver.readRLEBytes(stream);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(privateData);){
            List<KeyPair> list = this.readPrivateKeys(resourceKey, context, publicKeys, passwordProvider, bais);
            return list;
        }
    }

    protected PublicKey readPublicKey(String resourceKey, OpenSSHParserContext context, InputStream stream) throws IOException, GeneralSecurityException {
        byte[] keyData = KeyEntryResolver.readRLEBytes(stream);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(keyData);){
            String keyType = KeyEntryResolver.decodeString(bais);
            PublicKeyEntryDecoder<?, ?> decoder = KeyUtils.getPublicKeyEntryDecoder(keyType);
            if (decoder == null) {
                throw new NoSuchAlgorithmException("Unsupported key type (" + keyType + ") in " + resourceKey);
            }
            Object obj = decoder.decodePublicKey(keyType, bais);
            return obj;
        }
    }

    protected List<KeyPair> readPrivateKeys(String resourceKey, OpenSSHParserContext context, Collection<? extends PublicKey> publicKeys, FilePasswordProvider passwordProvider, InputStream stream) throws IOException, GeneralSecurityException {
        if (GenericUtils.isEmpty(publicKeys)) {
            return Collections.emptyList();
        }
        boolean traceEnabled = this.log.isTraceEnabled();
        int check1 = KeyEntryResolver.decodeInt(stream);
        int check2 = KeyEntryResolver.decodeInt(stream);
        if (traceEnabled) {
            this.log.trace("readPrivateKeys({}) check1=0x{}, check2=0x{}", new Object[]{resourceKey, Integer.toHexString(check1), Integer.toHexString(check2)});
        }
        ArrayList<KeyPair> keyPairs = new ArrayList<KeyPair>(publicKeys.size());
        for (PublicKey publicKey : publicKeys) {
            AbstractMap.SimpleImmutableEntry<PrivateKey, String> prvData;
            String pubType = KeyUtils.getKeyType(publicKey);
            int keyIndex = keyPairs.size() + 1;
            if (traceEnabled) {
                this.log.trace("extractKeyPairs({}) read private key #{}: {}", new Object[]{resourceKey, keyIndex, pubType});
            }
            PrivateKey prvKey = (prvData = this.readPrivateKey(resourceKey, context, pubType, passwordProvider, stream)) == null ? null : (PrivateKey)prvData.getKey();
            ValidateUtils.checkNotNull(prvKey, "Empty private key #%d in %s", keyIndex, resourceKey);
            String prvType = KeyUtils.getKeyType(prvKey);
            ValidateUtils.checkTrue(Objects.equals(pubType, prvType), "Mismatched public (%s) vs. private (%s) key type #%d in %s", pubType, prvType, keyIndex, resourceKey);
            if (traceEnabled) {
                this.log.trace("extractKeyPairs({}) add private key #{}: {} {}", new Object[]{resourceKey, keyIndex, prvType, prvData.getValue()});
            }
            keyPairs.add(new KeyPair(publicKey, prvKey));
        }
        return keyPairs;
    }

    protected AbstractMap.SimpleImmutableEntry<PrivateKey, String> readPrivateKey(String resourceKey, OpenSSHParserContext context, String keyType, FilePasswordProvider passwordProvider, InputStream stream) throws IOException, GeneralSecurityException {
        String prvType = KeyEntryResolver.decodeString(stream);
        if (!Objects.equals(keyType, prvType)) {
            throw new StreamCorruptedException("Mismatched private key type: , expected=" + keyType + ", actual=" + prvType + " in " + resourceKey);
        }
        PrivateKeyEntryDecoder<?, ?> decoder = OpenSSHKeyPairResourceParser.getPrivateKeyEntryDecoder(prvType);
        if (decoder == null) {
            throw new NoSuchAlgorithmException("Unsupported key type (" + prvType + ") in " + resourceKey);
        }
        Object prvKey = decoder.decodePrivateKey(prvType, passwordProvider, stream);
        if (prvKey == null) {
            throw new InvalidKeyException("Cannot parse key type (" + prvType + ") in " + resourceKey);
        }
        String comment = KeyEntryResolver.decodeString(stream);
        return new AbstractMap.SimpleImmutableEntry<PrivateKey, String>((PrivateKey)prvKey, comment);
    }

    protected <S extends InputStream> S validateStreamMagicMarker(String resourceKey, S stream) throws IOException {
        byte[] actual = new byte[AUTH_MAGIC_BYTES.length];
        IoUtils.readFully(stream, actual);
        if (!Arrays.equals(AUTH_MAGIC_BYTES, actual)) {
            throw new StreamCorruptedException(resourceKey + ": Mismatched magic marker value: " + BufferUtils.toHex(':', actual));
        }
        int eos = stream.read();
        if (eos == -1) {
            throw new EOFException(resourceKey + ": Premature EOF after magic marker value");
        }
        if (eos != 0) {
            throw new StreamCorruptedException(resourceKey + ": Missing EOS after magic marker value: 0x" + Integer.toHexString(eos));
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPrivateKeyEntryDecoder(PrivateKeyEntryDecoder<?, ?> decoder) {
        Objects.requireNonNull(decoder, "No decoder specified");
        Class pubType = Objects.requireNonNull(decoder.getPublicKeyType(), "No public key type declared");
        Class prvType = Objects.requireNonNull(decoder.getPrivateKeyType(), "No private key type declared");
        Map<Class<?>, PrivateKeyEntryDecoder<?, ?>> map = BY_KEY_CLASS_DECODERS_MAP;
        synchronized (map) {
            BY_KEY_CLASS_DECODERS_MAP.put(pubType, decoder);
            BY_KEY_CLASS_DECODERS_MAP.put(prvType, decoder);
        }
        Collection<String> names = ValidateUtils.checkNotNullAndNotEmpty(decoder.getSupportedTypeNames(), "No supported key type", new Object[0]);
        Map<String, PrivateKeyEntryDecoder<?, ?>> map2 = BY_KEY_TYPE_DECODERS_MAP;
        synchronized (map2) {
            for (String n : names) {
                PrivateKeyEntryDecoder<?, ?> prev = BY_KEY_TYPE_DECODERS_MAP.put(n, decoder);
                if (prev == null) continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKeyEntryDecoder<?, ?> getPrivateKeyEntryDecoder(String keyType) {
        if (GenericUtils.isEmpty(keyType)) {
            return null;
        }
        Map<String, PrivateKeyEntryDecoder<?, ?>> map = BY_KEY_TYPE_DECODERS_MAP;
        synchronized (map) {
            return BY_KEY_TYPE_DECODERS_MAP.get(keyType);
        }
    }

    public static PrivateKeyEntryDecoder<?, ?> getPrivateKeyEntryDecoder(KeyPair kp) {
        PrivateKeyEntryDecoder<?, ?> d2;
        if (kp == null) {
            return null;
        }
        PrivateKeyEntryDecoder<?, ?> d1 = OpenSSHKeyPairResourceParser.getPrivateKeyEntryDecoder(kp.getPublic());
        if (d1 == (d2 = OpenSSHKeyPairResourceParser.getPrivateKeyEntryDecoder(kp.getPrivate()))) {
            return d1;
        }
        return null;
    }

    public static PrivateKeyEntryDecoder<?, ?> getPrivateKeyEntryDecoder(Key key) {
        if (key == null) {
            return null;
        }
        return OpenSSHKeyPairResourceParser.getPrivateKeyEntryDecoder(key.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKeyEntryDecoder<?, ?> getPrivateKeyEntryDecoder(Class<?> keyType) {
        if (keyType == null || !Key.class.isAssignableFrom(keyType)) {
            return null;
        }
        Map<String, PrivateKeyEntryDecoder<?, ?>> map = BY_KEY_TYPE_DECODERS_MAP;
        synchronized (map) {
            PrivateKeyEntryDecoder<?, ?> decoder = BY_KEY_CLASS_DECODERS_MAP.get(keyType);
            if (decoder != null) {
                return decoder;
            }
            for (PrivateKeyEntryDecoder<?, ?> dec : BY_KEY_CLASS_DECODERS_MAP.values()) {
                Class pubType = dec.getPublicKeyType();
                Class prvType = dec.getPrivateKeyType();
                if (!pubType.isAssignableFrom(keyType) && !prvType.isAssignableFrom(keyType)) continue;
                return dec;
            }
        }
        return null;
    }

    static {
        OpenSSHKeyPairResourceParser.registerPrivateKeyEntryDecoder(OpenSSHRSAPrivateKeyDecoder.INSTANCE);
        OpenSSHKeyPairResourceParser.registerPrivateKeyEntryDecoder(OpenSSHDSSPrivateKeyEntryDecoder.INSTANCE);
        if (SecurityUtils.isECCSupported()) {
            OpenSSHKeyPairResourceParser.registerPrivateKeyEntryDecoder(OpenSSHECDSAPrivateKeyEntryDecoder.INSTANCE);
        }
        if (SecurityUtils.isEDDSACurveSupported()) {
            OpenSSHKeyPairResourceParser.registerPrivateKeyEntryDecoder(SecurityUtils.getOpenSSHEDDSAPrivateKeyEntryDecoder());
        }
    }
}

